/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeTransitGatewaysRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeTransitGatewaysRequestMarshaller
implements Marshaller<Request<DescribeTransitGatewaysRequest>, DescribeTransitGatewaysRequest> {
    @Override
    public Request<DescribeTransitGatewaysRequest> marshall(DescribeTransitGatewaysRequest describeTransitGatewaysRequest) {
        SdkInternalList describeTransitGatewaysRequestFiltersList;
        if (describeTransitGatewaysRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeTransitGatewaysRequest> request = new DefaultRequest<DescribeTransitGatewaysRequest>(describeTransitGatewaysRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeTransitGateways");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeTransitGatewaysRequestTransitGatewayIdsList = (SdkInternalList)describeTransitGatewaysRequest.getTransitGatewayIds();
        if (!describeTransitGatewaysRequestTransitGatewayIdsList.isEmpty() || !describeTransitGatewaysRequestTransitGatewayIdsList.isAutoConstruct()) {
            int transitGatewayIdsListIndex = 1;
            for (String describeTransitGatewaysRequestTransitGatewayIdsListValue : describeTransitGatewaysRequestTransitGatewayIdsList) {
                if (describeTransitGatewaysRequestTransitGatewayIdsListValue != null) {
                    request.addParameter("TransitGatewayIds." + transitGatewayIdsListIndex, StringUtils.fromString(describeTransitGatewaysRequestTransitGatewayIdsListValue));
                }
                ++transitGatewayIdsListIndex;
            }
        }
        if (!(describeTransitGatewaysRequestFiltersList = (SdkInternalList)describeTransitGatewaysRequest.getFilters()).isEmpty() || !describeTransitGatewaysRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeTransitGatewaysRequestFiltersListValue : describeTransitGatewaysRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeTransitGatewaysRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString(describeTransitGatewaysRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeTransitGatewaysRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString(filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeTransitGatewaysRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger(describeTransitGatewaysRequest.getMaxResults()));
        }
        if (describeTransitGatewaysRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString(describeTransitGatewaysRequest.getNextToken()));
        }
        return request;
    }
}

