/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ModifyVpcEndpointRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyVpcEndpointRequestMarshaller
implements Marshaller<Request<ModifyVpcEndpointRequest>, ModifyVpcEndpointRequest> {
    @Override
    public Request<ModifyVpcEndpointRequest> marshall(ModifyVpcEndpointRequest modifyVpcEndpointRequest) {
        SdkInternalList modifyVpcEndpointRequestRemoveSecurityGroupIdsList;
        SdkInternalList modifyVpcEndpointRequestAddSecurityGroupIdsList;
        SdkInternalList modifyVpcEndpointRequestRemoveSubnetIdsList;
        SdkInternalList modifyVpcEndpointRequestAddSubnetIdsList;
        SdkInternalList modifyVpcEndpointRequestRemoveRouteTableIdsList;
        SdkInternalList modifyVpcEndpointRequestAddRouteTableIdsList;
        if (modifyVpcEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyVpcEndpointRequest> request = new DefaultRequest<ModifyVpcEndpointRequest>(modifyVpcEndpointRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVpcEndpoint");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVpcEndpointRequest.getVpcEndpointId() != null) {
            request.addParameter("VpcEndpointId", StringUtils.fromString(modifyVpcEndpointRequest.getVpcEndpointId()));
        }
        if (modifyVpcEndpointRequest.getResetPolicy() != null) {
            request.addParameter("ResetPolicy", StringUtils.fromBoolean(modifyVpcEndpointRequest.getResetPolicy()));
        }
        if (modifyVpcEndpointRequest.getPolicyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString(modifyVpcEndpointRequest.getPolicyDocument()));
        }
        if (!(modifyVpcEndpointRequestAddRouteTableIdsList = (SdkInternalList)modifyVpcEndpointRequest.getAddRouteTableIds()).isEmpty() || !modifyVpcEndpointRequestAddRouteTableIdsList.isAutoConstruct()) {
            int addRouteTableIdsListIndex = 1;
            for (Object modifyVpcEndpointRequestAddRouteTableIdsListValue : modifyVpcEndpointRequestAddRouteTableIdsList) {
                if (modifyVpcEndpointRequestAddRouteTableIdsListValue != null) {
                    request.addParameter("AddRouteTableId." + addRouteTableIdsListIndex, StringUtils.fromString((String)modifyVpcEndpointRequestAddRouteTableIdsListValue));
                }
                ++addRouteTableIdsListIndex;
            }
        }
        if (!(modifyVpcEndpointRequestRemoveRouteTableIdsList = (SdkInternalList)modifyVpcEndpointRequest.getRemoveRouteTableIds()).isEmpty() || !modifyVpcEndpointRequestRemoveRouteTableIdsList.isAutoConstruct()) {
            int removeRouteTableIdsListIndex = 1;
            for (Object modifyVpcEndpointRequestRemoveRouteTableIdsListValue : modifyVpcEndpointRequestRemoveRouteTableIdsList) {
                if (modifyVpcEndpointRequestRemoveRouteTableIdsListValue != null) {
                    request.addParameter("RemoveRouteTableId." + removeRouteTableIdsListIndex, StringUtils.fromString((String)modifyVpcEndpointRequestRemoveRouteTableIdsListValue));
                }
                ++removeRouteTableIdsListIndex;
            }
        }
        if (!(modifyVpcEndpointRequestAddSubnetIdsList = (SdkInternalList)modifyVpcEndpointRequest.getAddSubnetIds()).isEmpty() || !modifyVpcEndpointRequestAddSubnetIdsList.isAutoConstruct()) {
            int addSubnetIdsListIndex = 1;
            for (Object modifyVpcEndpointRequestAddSubnetIdsListValue : modifyVpcEndpointRequestAddSubnetIdsList) {
                if (modifyVpcEndpointRequestAddSubnetIdsListValue != null) {
                    request.addParameter("AddSubnetId." + addSubnetIdsListIndex, StringUtils.fromString((String)modifyVpcEndpointRequestAddSubnetIdsListValue));
                }
                ++addSubnetIdsListIndex;
            }
        }
        if (!(modifyVpcEndpointRequestRemoveSubnetIdsList = (SdkInternalList)modifyVpcEndpointRequest.getRemoveSubnetIds()).isEmpty() || !modifyVpcEndpointRequestRemoveSubnetIdsList.isAutoConstruct()) {
            int removeSubnetIdsListIndex = 1;
            for (Object modifyVpcEndpointRequestRemoveSubnetIdsListValue : modifyVpcEndpointRequestRemoveSubnetIdsList) {
                if (modifyVpcEndpointRequestRemoveSubnetIdsListValue != null) {
                    request.addParameter("RemoveSubnetId." + removeSubnetIdsListIndex, StringUtils.fromString((String)modifyVpcEndpointRequestRemoveSubnetIdsListValue));
                }
                ++removeSubnetIdsListIndex;
            }
        }
        if (!(modifyVpcEndpointRequestAddSecurityGroupIdsList = (SdkInternalList)modifyVpcEndpointRequest.getAddSecurityGroupIds()).isEmpty() || !modifyVpcEndpointRequestAddSecurityGroupIdsList.isAutoConstruct()) {
            int addSecurityGroupIdsListIndex = 1;
            for (String modifyVpcEndpointRequestAddSecurityGroupIdsListValue : modifyVpcEndpointRequestAddSecurityGroupIdsList) {
                if (modifyVpcEndpointRequestAddSecurityGroupIdsListValue != null) {
                    request.addParameter("AddSecurityGroupId." + addSecurityGroupIdsListIndex, StringUtils.fromString(modifyVpcEndpointRequestAddSecurityGroupIdsListValue));
                }
                ++addSecurityGroupIdsListIndex;
            }
        }
        if (!(modifyVpcEndpointRequestRemoveSecurityGroupIdsList = (SdkInternalList)modifyVpcEndpointRequest.getRemoveSecurityGroupIds()).isEmpty() || !modifyVpcEndpointRequestRemoveSecurityGroupIdsList.isAutoConstruct()) {
            int removeSecurityGroupIdsListIndex = 1;
            for (String modifyVpcEndpointRequestRemoveSecurityGroupIdsListValue : modifyVpcEndpointRequestRemoveSecurityGroupIdsList) {
                if (modifyVpcEndpointRequestRemoveSecurityGroupIdsListValue != null) {
                    request.addParameter("RemoveSecurityGroupId." + removeSecurityGroupIdsListIndex, StringUtils.fromString(modifyVpcEndpointRequestRemoveSecurityGroupIdsListValue));
                }
                ++removeSecurityGroupIdsListIndex;
            }
        }
        if (modifyVpcEndpointRequest.getPrivateDnsEnabled() != null) {
            request.addParameter("PrivateDnsEnabled", StringUtils.fromBoolean(modifyVpcEndpointRequest.getPrivateDnsEnabled()));
        }
        return request;
    }
}

