/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.VCpuInfo;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class VCpuInfoStaxUnmarshaller
implements Unmarshaller<VCpuInfo, StaxUnmarshallerContext> {
    private static VCpuInfoStaxUnmarshaller instance;

    @Override
    public VCpuInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        VCpuInfo vCpuInfo = new VCpuInfo();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return vCpuInfo;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("defaultVCpus", targetDepth)) {
                    vCpuInfo.setDefaultVCpus(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("defaultCores", targetDepth)) {
                    vCpuInfo.setDefaultCores(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("defaultThreadsPerCore", targetDepth)) {
                    vCpuInfo.setDefaultThreadsPerCore(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("validCores", targetDepth)) {
                    vCpuInfo.withValidCores(new ArrayList<Integer>());
                    continue;
                }
                if (context.testExpression("validCores/item", targetDepth)) {
                    vCpuInfo.withValidCores(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("validThreadsPerCore", targetDepth)) {
                    vCpuInfo.withValidThreadsPerCore(new ArrayList<Integer>());
                    continue;
                }
                if (!context.testExpression("validThreadsPerCore/item", targetDepth)) continue;
                vCpuInfo.withValidThreadsPerCore(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return vCpuInfo;
    }

    public static VCpuInfoStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new VCpuInfoStaxUnmarshaller();
        }
        return instance;
    }
}

