/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.collector.collectors;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.List;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.graylog.plugins.collector.collectors.AutoValue_CollectorNodeDetails;
import org.graylog.plugins.collector.collectors.rest.models.CollectorLogFile;
import org.graylog.plugins.collector.collectors.rest.models.CollectorMetrics;
import org.graylog.plugins.collector.collectors.rest.models.CollectorNodeDetailsSummary;
import org.graylog.plugins.collector.collectors.rest.models.CollectorStatusList;

@JsonAutoDetect
@AutoValue
public abstract class CollectorNodeDetails {
    @JsonProperty(value="operating_system")
    @NotNull
    @Size(min=1)
    public abstract @NotNull @Size(min=1) String operatingSystem();

    @JsonProperty(value="tags")
    @Nullable
    public abstract List<String> tags();

    @JsonProperty(value="ip")
    @Nullable
    public abstract String ip();

    @JsonProperty(value="metrics")
    @Nullable
    public abstract CollectorMetrics metrics();

    @JsonProperty(value="log_file_list")
    @Nullable
    public abstract List<CollectorLogFile> logFileList();

    @JsonProperty(value="status")
    @Nullable
    public abstract CollectorStatusList statusList();

    @JsonCreator
    public static CollectorNodeDetails create(@JsonProperty(value="operating_system") String operatingSystem, @JsonProperty(value="tags") @Nullable List<String> tags, @JsonProperty(value="ip") @Nullable String ip, @JsonProperty(value="metrics") @Nullable CollectorMetrics metrics, @JsonProperty(value="log_file_list") @Nullable List<CollectorLogFile> logFileList, @JsonProperty(value="status") @Nullable CollectorStatusList statusList) {
        return new AutoValue_CollectorNodeDetails(operatingSystem, tags, ip, metrics, logFileList, statusList);
    }

    public CollectorNodeDetailsSummary toSummary() {
        return CollectorNodeDetailsSummary.create(this.operatingSystem(), this.tags(), this.ip(), this.metrics(), this.logFileList(), this.statusList());
    }
}

