/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.collector.configurations.rest.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import java.util.List;
import javax.annotation.Nullable;
import org.graylog.plugins.collector.configurations.rest.models.AutoValue_CollectorConfiguration;
import org.graylog.plugins.collector.configurations.rest.models.CollectorConfigurationSnippet;
import org.graylog.plugins.collector.configurations.rest.models.CollectorInput;
import org.graylog.plugins.collector.configurations.rest.models.CollectorOutput;
import org.hibernate.validator.constraints.NotEmpty;
import org.mongojack.Id;
import org.mongojack.ObjectId;

@AutoValue
public abstract class CollectorConfiguration {
    @JsonProperty(value="id")
    @Nullable
    @Id
    @ObjectId
    public abstract String id();

    @JsonProperty(value="name")
    public abstract String name();

    @JsonProperty
    public abstract List<String> tags();

    @JsonProperty
    public abstract List<CollectorInput> inputs();

    @JsonProperty
    public abstract List<CollectorOutput> outputs();

    @JsonProperty
    public abstract List<CollectorConfigurationSnippet> snippets();

    @JsonCreator
    public static CollectorConfiguration create(@JsonProperty(value="id") @Id @ObjectId String id, @JsonProperty(value="name") String name, @JsonProperty(value="tags") List<String> tags, @JsonProperty(value="inputs") List<CollectorInput> inputs, @JsonProperty(value="outputs") List<CollectorOutput> outputs, @JsonProperty(value="snippets") List<CollectorConfigurationSnippet> snippets) {
        return CollectorConfiguration.builder().id(id).name(name).tags(tags).inputs(inputs).outputs(outputs).snippets(snippets).build();
    }

    public static CollectorConfiguration create(@NotEmpty String name, @NotEmpty List<String> tags, @NotEmpty List<CollectorInput> inputs, @NotEmpty List<CollectorOutput> outputs, @NotEmpty List<CollectorConfigurationSnippet> snippets) {
        return CollectorConfiguration.create(new org.bson.types.ObjectId().toHexString(), name, tags, inputs, outputs, snippets);
    }

    public void mergeWith(CollectorConfiguration collectorConfiguration) {
        if (collectorConfiguration.inputs() != null) {
            this.inputs().addAll(collectorConfiguration.inputs());
        }
        if (collectorConfiguration.outputs() != null) {
            this.outputs().addAll(collectorConfiguration.outputs());
        }
        if (collectorConfiguration.snippets() != null) {
            this.snippets().addAll(collectorConfiguration.snippets());
        }
    }

    public static Builder builder() {
        return new AutoValue_CollectorConfiguration.Builder();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract CollectorConfiguration build();

        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder tags(List<String> var1);

        public abstract Builder inputs(List<CollectorInput> var1);

        public abstract Builder outputs(List<CollectorOutput> var1);

        public abstract Builder snippets(List<CollectorConfigurationSnippet> var1);
    }
}

