/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.standard;

import java.io.IOException;
import java.io.Reader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.CharArraySet;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.LowerCaseFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.StopFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.TokenFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.standard.ClassicFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.analysis.standard.ClassicTokenizer;

public final class ClassicAnalyzer
extends StopwordAnalyzerBase {
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;
    public static final CharArraySet STOP_WORDS_SET = EnglishAnalyzer.ENGLISH_STOP_WORDS_SET;

    public ClassicAnalyzer(CharArraySet stopWords) {
        super(stopWords);
    }

    public ClassicAnalyzer() {
        this(STOP_WORDS_SET);
    }

    public ClassicAnalyzer(Reader stopwords) throws IOException {
        this(ClassicAnalyzer.loadStopwordSet(stopwords));
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        ClassicTokenizer src = new ClassicTokenizer();
        src.setMaxTokenLength(this.maxTokenLength);
        TokenFilter tok = new ClassicFilter(src);
        tok = new LowerCaseFilter(tok);
        tok = new StopFilter(tok, this.stopwords);
        return new Analyzer.TokenStreamComponents(r -> {
            src.setMaxTokenLength(this.maxTokenLength);
            src.setReader((Reader)r);
        }, (TokenStream)tok);
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        return new LowerCaseFilter(in);
    }
}

