/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.document;

import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.Field;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.FieldType;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.XYDocValuesPointInGeometryQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.XYPointSortField;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.XYCircle;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.XYEncodingUtils;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.XYPolygon;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.geo.XYRectangle;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.DocValuesType;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.SortField;

public class XYDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public XYDocValuesField(String name, float x, float y) {
        super(name, TYPE);
        this.setLocationValue(x, y);
    }

    public void setLocationValue(float x, float y) {
        int xEncoded = XYEncodingUtils.encode(x);
        int yEncoded = XYEncodingUtils.encode(y);
        this.fieldsData = (long)xEncoded << 32 | (long)yEncoded & 0xFFFFFFFFL;
    }

    static void checkCompatible(FieldInfo fieldInfo) {
        if (fieldInfo.getDocValuesType() != DocValuesType.NONE && fieldInfo.getDocValuesType() != TYPE.docValuesType()) {
            throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with docValuesType=" + (Object)((Object)fieldInfo.getDocValuesType()) + " but this type has docValuesType=" + (Object)((Object)TYPE.docValuesType()) + ", is the field really a XYDocValuesField?");
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        long currentValue = (Long)this.fieldsData;
        result.append(XYEncodingUtils.decode((int)(currentValue >> 32)));
        result.append(',');
        result.append(XYEncodingUtils.decode((int)(currentValue & 0xFFFFFFFFFFFFFFFFL)));
        result.append('>');
        return result.toString();
    }

    public static SortField newDistanceSort(String field, float x, float y) {
        return new XYPointSortField(field, x, y);
    }

    public static Query newSlowBoxQuery(String field, float minX, float maxX, float minY, float maxY) {
        XYRectangle rectangle = new XYRectangle(minX, maxX, minY, maxY);
        return new XYDocValuesPointInGeometryQuery(field, rectangle);
    }

    public static Query newSlowDistanceQuery(String field, float x, float y, float radius) {
        XYCircle circle = new XYCircle(x, y, radius);
        return new XYDocValuesPointInGeometryQuery(field, circle);
    }

    public static Query newSlowPolygonQuery(String field, XYPolygon ... polygons) {
        return new XYDocValuesPointInGeometryQuery(field, polygons);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED_NUMERIC);
        TYPE.freeze();
    }
}

