/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.Document;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.DocumentStoredFieldVisitor;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.CompositeReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.Fields;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.StoredFieldVisitor;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.Term;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.Terms;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.AlreadyClosedException;

public abstract class IndexReader
implements Closeable {
    private boolean closed = false;
    private boolean closedByChild = false;
    private final AtomicInteger refCount = new AtomicInteger(1);
    private final Set<IndexReader> parentReaders = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));

    IndexReader() {
        if (!(this instanceof CompositeReader) && !(this instanceof LeafReader)) {
            throw new Error("IndexReader should never be directly extended, subclass LeafReader or CompositeReader instead.");
        }
    }

    public final void registerParentReader(IndexReader reader) {
        this.ensureOpen();
        this.parentReaders.add(reader);
    }

    void notifyReaderClosedListeners() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportCloseToParentReaders() throws IOException {
        Set<IndexReader> set = this.parentReaders;
        synchronized (set) {
            for (IndexReader parent : this.parentReaders) {
                parent.closedByChild = true;
                parent.refCount.addAndGet(0);
                parent.reportCloseToParentReaders();
            }
        }
    }

    public final int getRefCount() {
        return this.refCount.get();
    }

    public final void incRef() {
        if (!this.tryIncRef()) {
            this.ensureOpen();
        }
    }

    public final boolean tryIncRef() {
        int count;
        while ((count = this.refCount.get()) > 0) {
            if (!this.refCount.compareAndSet(count, count + 1)) continue;
            return true;
        }
        return false;
    }

    public final void decRef() throws IOException {
        block27: {
            if (this.refCount.get() <= 0) {
                throw new AlreadyClosedException("this IndexReader is closed");
            }
            int rc = this.refCount.decrementAndGet();
            if (rc == 0) {
                this.closed = true;
                try (Closeable finalizer = this::reportCloseToParentReaders;
                     Closeable finalizer1 = this::notifyReaderClosedListeners;){
                    this.doClose();
                    break block27;
                }
            }
            if (rc < 0) {
                throw new IllegalStateException("too many decRef calls: refCount is " + rc + " after decrement");
            }
        }
    }

    protected final void ensureOpen() throws AlreadyClosedException {
        if (this.refCount.get() <= 0) {
            throw new AlreadyClosedException("this IndexReader is closed");
        }
        if (this.closedByChild) {
            throw new AlreadyClosedException("this IndexReader cannot be used anymore as one of its child readers was closed");
        }
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public abstract Fields getTermVectors(int var1) throws IOException;

    public final Terms getTermVector(int docID, String field) throws IOException {
        Fields vectors = this.getTermVectors(docID);
        if (vectors == null) {
            return null;
        }
        return vectors.terms(field);
    }

    public abstract int numDocs();

    public abstract int maxDoc();

    public final int numDeletedDocs() {
        return this.maxDoc() - this.numDocs();
    }

    public abstract void document(int var1, StoredFieldVisitor var2) throws IOException;

    public final Document document(int docID) throws IOException {
        DocumentStoredFieldVisitor visitor = new DocumentStoredFieldVisitor();
        this.document(docID, visitor);
        return visitor.getDocument();
    }

    public final Document document(int docID, Set<String> fieldsToLoad) throws IOException {
        DocumentStoredFieldVisitor visitor = new DocumentStoredFieldVisitor(fieldsToLoad);
        this.document(docID, visitor);
        return visitor.getDocument();
    }

    public boolean hasDeletions() {
        return this.numDeletedDocs() > 0;
    }

    @Override
    public final synchronized void close() throws IOException {
        if (!this.closed) {
            this.decRef();
            this.closed = true;
        }
    }

    protected abstract void doClose() throws IOException;

    public abstract IndexReaderContext getContext();

    public final List<LeafReaderContext> leaves() {
        return this.getContext().leaves();
    }

    public abstract CacheHelper getReaderCacheHelper();

    public abstract int docFreq(Term var1) throws IOException;

    public abstract long totalTermFreq(Term var1) throws IOException;

    public abstract long getSumDocFreq(String var1) throws IOException;

    public abstract int getDocCount(String var1) throws IOException;

    public abstract long getSumTotalTermFreq(String var1) throws IOException;

    @FunctionalInterface
    public static interface ClosedListener {
        public void onClose(CacheKey var1) throws IOException;
    }

    public static final class CacheKey {
        CacheKey() {
        }
    }

    public static interface CacheHelper {
        public CacheKey getKey();

        public void addClosedListener(ClosedListener var1);
    }
}

