/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.index;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.BaseCompositeReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.CodecReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.DirectoryReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.FilterCodecReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexWriter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexWriterConfig;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.MultiReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.SlowCodecReaderWrapper;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.Directory;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.FSDirectory;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.Bits;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.FixedBitSet;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.SuppressForbidden;

@SuppressForbidden(reason="System.out required: command line tool")
public class MultiPassIndexSplitter {
    public void split(IndexReader in, Directory[] outputs, boolean seq) throws IOException {
        if (outputs == null || outputs.length < 2) {
            throw new IOException("Invalid number of outputs.");
        }
        if (in == null || in.numDocs() < 2) {
            throw new IOException("Not enough documents for splitting");
        }
        int numParts = outputs.length;
        FakeDeleteIndexReader input = new FakeDeleteIndexReader(in);
        int maxDoc = input.maxDoc();
        int partLen = maxDoc / numParts;
        for (int i = 0; i < numParts; ++i) {
            input.undeleteAll();
            if (seq) {
                int j;
                int lo = partLen * i;
                int hi = lo + partLen;
                for (j = 0; j < lo; ++j) {
                    input.deleteDocument(j);
                }
                if (i < numParts - 1) {
                    for (j = hi; j < maxDoc; ++j) {
                        input.deleteDocument(j);
                    }
                }
            } else {
                for (int j = 0; j < maxDoc; ++j) {
                    if ((j + numParts - i) % numParts == 0) continue;
                    input.deleteDocument(j);
                }
            }
            IndexWriter w = new IndexWriter(outputs[i], new IndexWriterConfig(null).setOpenMode(IndexWriterConfig.OpenMode.CREATE));
            System.err.println("Writing part " + (i + 1) + " ...");
            List sr = input.getSequentialSubReaders();
            w.addIndexes(sr.toArray(new CodecReader[sr.size()]));
            w.close();
        }
        System.err.println("Done.");
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 5) {
            System.err.println("Usage: MultiPassIndexSplitter -out <outputDir> -num <numParts> [-seq] <inputIndex1> [<inputIndex2 ...]");
            System.err.println("\tinputIndex\tpath to input index, multiple values are ok");
            System.err.println("\t-out ouputDir\tpath to output directory to contain partial indexes");
            System.err.println("\t-num numParts\tnumber of parts to produce");
            System.err.println("\t-seq\tsequential docid-range split (default is round-robin)");
            System.exit(-1);
        }
        ArrayList<DirectoryReader> indexes = new ArrayList<DirectoryReader>();
        String outDir = null;
        int numParts = -1;
        boolean seq = false;
        for (int i = 0; i < args.length; ++i) {
            FSDirectory dir;
            block13: {
                if (args[i].equals("-out")) {
                    outDir = args[++i];
                    continue;
                }
                if (args[i].equals("-num")) {
                    numParts = Integer.parseInt(args[++i]);
                    continue;
                }
                if (args[i].equals("-seq")) {
                    seq = true;
                    continue;
                }
                Path file = Paths.get(args[i], new String[0]);
                if (!Files.isDirectory(file, new LinkOption[0])) {
                    System.err.println("Invalid input path - skipping: " + file);
                    continue;
                }
                dir = FSDirectory.open(file);
                try {
                    if (!DirectoryReader.indexExists(dir)) {
                        System.err.println("Invalid input index - skipping: " + file);
                    }
                    break block13;
                }
                catch (Exception e) {
                    System.err.println("Invalid input index - skipping: " + file);
                }
                continue;
            }
            indexes.add(DirectoryReader.open(dir));
        }
        if (outDir == null) {
            throw new Exception("Required argument missing: -out outputDir");
        }
        if (numParts < 2) {
            throw new Exception("Invalid value of required argument: -num numParts");
        }
        if (indexes.size() == 0) {
            throw new Exception("No input indexes to process");
        }
        Path out = Paths.get(outDir, new String[0]);
        Files.createDirectories(out, new FileAttribute[0]);
        Directory[] dirs = new Directory[numParts];
        for (int i = 0; i < numParts; ++i) {
            dirs[i] = FSDirectory.open(out.resolve("part-" + i));
        }
        MultiPassIndexSplitter splitter = new MultiPassIndexSplitter();
        IndexReader input = indexes.size() == 1 ? (IndexReader)indexes.get(0) : new MultiReader(indexes.toArray(new IndexReader[indexes.size()]));
        splitter.split(input, dirs, seq);
    }

    private static final class FakeDeleteLeafIndexReader
    extends FilterCodecReader {
        FixedBitSet liveDocs;

        public FakeDeleteLeafIndexReader(CodecReader reader) {
            super(reader);
            this.undeleteAll();
        }

        @Override
        public int numDocs() {
            return this.liveDocs.cardinality();
        }

        public void undeleteAll() {
            int maxDoc = this.in.maxDoc();
            this.liveDocs = new FixedBitSet(this.in.maxDoc());
            if (this.in.hasDeletions()) {
                Bits oldLiveDocs = this.in.getLiveDocs();
                assert (oldLiveDocs != null);
                for (int i = 0; i < maxDoc; ++i) {
                    if (!oldLiveDocs.get(i)) continue;
                    this.liveDocs.set(i);
                }
            } else {
                this.liveDocs.set(0, maxDoc);
            }
        }

        public void deleteDocument(int n) {
            this.liveDocs.clear(n);
        }

        @Override
        public Bits getLiveDocs() {
            return this.liveDocs;
        }

        @Override
        public IndexReader.CacheHelper getCoreCacheHelper() {
            return this.in.getCoreCacheHelper();
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }
    }

    private static final class FakeDeleteIndexReader
    extends BaseCompositeReader<FakeDeleteLeafIndexReader> {
        public FakeDeleteIndexReader(IndexReader reader) throws IOException {
            super((IndexReader[])FakeDeleteIndexReader.initSubReaders(reader));
        }

        private static FakeDeleteLeafIndexReader[] initSubReaders(IndexReader reader) throws IOException {
            List<LeafReaderContext> leaves = reader.leaves();
            FakeDeleteLeafIndexReader[] subs = new FakeDeleteLeafIndexReader[leaves.size()];
            int i = 0;
            for (LeafReaderContext ctx : leaves) {
                subs[i++] = new FakeDeleteLeafIndexReader(SlowCodecReaderWrapper.wrap(ctx.reader()));
            }
            return subs;
        }

        public void deleteDocument(int docID) {
            int i = this.readerIndex(docID);
            ((FakeDeleteLeafIndexReader)this.getSequentialSubReaders().get(i)).deleteDocument(docID - this.readerBase(i));
        }

        public void undeleteAll() {
            for (FakeDeleteLeafIndexReader r : this.getSequentialSubReaders()) {
                r.undeleteAll();
            }
        }

        @Override
        protected void doClose() {
        }

        @Override
        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }
    }
}

