/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.function.FunctionValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.function.ValueSource;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.function.valuesource.DocFreqValueSource;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.IndexSearcher;

public class MaxDocValueSource
extends ValueSource {
    public String name() {
        return "maxdoc";
    }

    @Override
    public String description() {
        return this.name() + "()";
    }

    @Override
    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        context.put("searcher", searcher);
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        IndexSearcher searcher = (IndexSearcher)context.get("searcher");
        return new DocFreqValueSource.ConstIntDocValues(searcher.getIndexReader().maxDoc(), this);
    }

    @Override
    public boolean equals(Object o) {
        return this.getClass() == o.getClass();
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

