/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.intervals;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.intervals.Disjunctions;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.intervals.IntervalFilter;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.intervals.IntervalIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.intervals.IntervalMatches;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.intervals.IntervalMatchesIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.intervals.Intervals;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queries.intervals.IntervalsSource;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.QueryVisitor;

public abstract class FilteredIntervalsSource
extends IntervalsSource {
    private final String name;
    protected final IntervalsSource in;

    public static IntervalsSource maxGaps(IntervalsSource in, int maxGaps) {
        return Intervals.or(in.pullUpDisjunctions().stream().map(s -> new MaxGaps((IntervalsSource)s, maxGaps)).collect(Collectors.toList()));
    }

    public static IntervalsSource maxWidth(IntervalsSource in, int maxWidth) {
        return new MaxWidth(in, maxWidth);
    }

    public FilteredIntervalsSource(String name, IntervalsSource in) {
        this.name = name;
        this.in = in;
    }

    protected abstract boolean accept(IntervalIterator var1);

    @Override
    public IntervalIterator intervals(String field, LeafReaderContext ctx) throws IOException {
        IntervalIterator i = this.in.intervals(field, ctx);
        if (i == null) {
            return null;
        }
        return new IntervalFilter(i){

            @Override
            protected boolean accept() {
                return FilteredIntervalsSource.this.accept(this.in);
            }
        };
    }

    @Override
    public IntervalMatchesIterator matches(String field, LeafReaderContext ctx, int doc) throws IOException {
        IntervalMatchesIterator mi = this.in.matches(field, ctx, doc);
        if (mi == null) {
            return null;
        }
        IntervalFilter filtered = new IntervalFilter(IntervalMatches.wrapMatches(mi, doc)){

            @Override
            protected boolean accept() {
                return FilteredIntervalsSource.this.accept(this.in);
            }
        };
        return IntervalMatches.asMatches(filtered, mi, doc);
    }

    @Override
    public int minExtent() {
        return this.in.minExtent();
    }

    @Override
    public Collection<IntervalsSource> pullUpDisjunctions() {
        return Collections.singletonList(this);
    }

    @Override
    public void visit(String field, QueryVisitor visitor) {
        this.in.visit(field, visitor);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof FilteredIntervalsSource)) {
            return false;
        }
        FilteredIntervalsSource that = (FilteredIntervalsSource)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.in, that.in);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.in);
    }

    @Override
    public String toString() {
        return this.name + "(" + this.in + ")";
    }

    private static class MaxWidth
    extends FilteredIntervalsSource {
        private final int maxWidth;

        MaxWidth(IntervalsSource in, int maxWidth) {
            super("MAXWIDTH/" + maxWidth, in);
            this.maxWidth = maxWidth;
        }

        @Override
        protected boolean accept(IntervalIterator it) {
            return it.end() - it.start() + 1 <= this.maxWidth;
        }

        @Override
        public Collection<IntervalsSource> pullUpDisjunctions() {
            return Disjunctions.pullUp(this.in, s -> new MaxWidth((IntervalsSource)s, this.maxWidth));
        }
    }

    private static class MaxGaps
    extends FilteredIntervalsSource {
        private final int maxGaps;

        MaxGaps(IntervalsSource in, int maxGaps) {
            super("MAXGAPS/" + maxGaps, in);
            this.maxGaps = maxGaps;
        }

        @Override
        protected boolean accept(IntervalIterator it) {
            return it.gaps() <= this.maxGaps;
        }
    }
}

