/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.queryparser.xml.builders;

import org.graylog.shaded.elasticsearch7.org.apache.lucene.queryparser.xml.DOMUtils;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queryparser.xml.ParserException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queryparser.xml.QueryBuilder;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.queryparser.xml.QueryBuilderFactory;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.BoostQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ConstantScoreQuery;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Query;
import org.w3c.dom.Element;

public class ConstantScoreQueryBuilder
implements QueryBuilder {
    private final QueryBuilderFactory queryFactory;

    public ConstantScoreQueryBuilder(QueryBuilderFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    @Override
    public Query getQuery(Element e) throws ParserException {
        Element queryElem = DOMUtils.getFirstChildOrFail(e);
        Query q = new ConstantScoreQuery(this.queryFactory.getQuery(queryElem));
        float boost = DOMUtils.getAttribute(e, "boost", 1.0f);
        if (boost != 1.0f) {
            q = new BoostQuery(q, boost);
        }
        return q;
    }
}

