/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DoubleValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DoubleValuesSource;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.FieldComparator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.FieldComparatorSource;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.LongValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorable;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.SegmentCacheable;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.SortField;

public abstract class LongValuesSource
implements SegmentCacheable {
    public abstract LongValues getValues(LeafReaderContext var1, DoubleValues var2) throws IOException;

    public abstract boolean needsScores();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract String toString();

    public abstract LongValuesSource rewrite(IndexSearcher var1) throws IOException;

    public SortField getSortField(boolean reverse) {
        return new LongValuesSortField(this, reverse);
    }

    public DoubleValuesSource toDoubleValuesSource() {
        return new DoubleLongValuesSource(this);
    }

    public static LongValuesSource fromLongField(String field) {
        return new FieldValuesSource(field);
    }

    public static LongValuesSource fromIntField(String field) {
        return LongValuesSource.fromLongField(field);
    }

    public static LongValuesSource constant(long value) {
        return new ConstantLongValuesSource(value);
    }

    private static LongValues toLongValues(final NumericDocValues in) {
        return new LongValues(){

            @Override
            public long longValue() throws IOException {
                return in.longValue();
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                return in.advanceExact(target);
            }
        };
    }

    private static NumericDocValues asNumericDocValues(final LongValuesHolder in) {
        return new NumericDocValues(){

            @Override
            public long longValue() throws IOException {
                return in.values.longValue();
            }

            @Override
            public boolean advanceExact(int target) throws IOException {
                return in.values.advanceExact(target);
            }

            @Override
            public int docID() {
                throw new UnsupportedOperationException();
            }

            @Override
            public int nextDoc() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public int advance(int target) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public long cost() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static class LongValuesComparatorSource
    extends FieldComparatorSource {
        private final LongValuesSource producer;
        private long missingValue;

        public LongValuesComparatorSource(LongValuesSource producer) {
            this.producer = producer;
            this.missingValue = 0L;
        }

        void setMissingValue(long missingValue) {
            this.missingValue = missingValue;
        }

        public FieldComparator<Long> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) {
            return new FieldComparator.LongComparator(numHits, fieldname, this.missingValue){
                LeafReaderContext ctx;
                LongValuesHolder holder;
                {
                    super(numHits, field, missingValue);
                    this.holder = new LongValuesHolder();
                }

                @Override
                protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                    this.ctx = context;
                    return LongValuesSource.asNumericDocValues(this.holder);
                }

                @Override
                public void setScorer(Scorable scorer) throws IOException {
                    this.holder.values = producer.getValues(this.ctx, DoubleValuesSource.fromScorer(scorer));
                }
            };
        }
    }

    private static class LongValuesHolder {
        LongValues values;

        private LongValuesHolder() {
        }
    }

    private static class LongValuesSortField
    extends SortField {
        final LongValuesSource producer;

        public LongValuesSortField(LongValuesSource producer, boolean reverse) {
            super(producer.toString(), new LongValuesComparatorSource(producer), reverse);
            this.producer = producer;
        }

        @Override
        public void setMissingValue(Object missingValue) {
            if (missingValue instanceof Number) {
                this.missingValue = missingValue;
                ((LongValuesComparatorSource)this.getComparatorSource()).setMissingValue(((Number)missingValue).longValue());
            } else {
                super.setMissingValue(missingValue);
            }
        }

        @Override
        public boolean needsScores() {
            return this.producer.needsScores();
        }

        @Override
        public String toString() {
            StringBuilder buffer = new StringBuilder("<");
            buffer.append(this.getField()).append(">");
            if (this.reverse) {
                buffer.append("!");
            }
            return buffer.toString();
        }

        @Override
        public SortField rewrite(IndexSearcher searcher) throws IOException {
            LongValuesSortField rewritten = new LongValuesSortField(this.producer.rewrite(searcher), this.reverse);
            if (this.missingValue != null) {
                rewritten.setMissingValue(this.missingValue);
            }
            return rewritten;
        }
    }

    private static class FieldValuesSource
    extends LongValuesSource {
        final String field;

        private FieldValuesSource(String field) {
            this.field = field;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldValuesSource that = (FieldValuesSource)o;
            return Objects.equals(this.field, that.field);
        }

        @Override
        public String toString() {
            return "long(" + this.field + ")";
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.field);
        }

        @Override
        public LongValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            NumericDocValues values = DocValues.getNumeric(ctx.reader(), this.field);
            return LongValuesSource.toLongValues(values);
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return DocValues.isCacheable(ctx, this.field);
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public LongValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return this;
        }
    }

    private static class ConstantLongValuesSource
    extends LongValuesSource {
        private final long value;

        private ConstantLongValuesSource(long value) {
            this.value = value;
        }

        @Override
        public LongValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            return new LongValues(){

                @Override
                public long longValue() throws IOException {
                    return value;
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return true;
                }
            };
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.value);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConstantLongValuesSource that = (ConstantLongValuesSource)o;
            return this.value == that.value;
        }

        @Override
        public String toString() {
            return "constant(" + this.value + ")";
        }

        @Override
        public LongValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return this;
        }
    }

    private static class DoubleLongValuesSource
    extends DoubleValuesSource {
        private final LongValuesSource inner;

        private DoubleLongValuesSource(LongValuesSource inner) {
            this.inner = inner;
        }

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
            final LongValues v = this.inner.getValues(ctx, scores);
            return new DoubleValues(){

                @Override
                public double doubleValue() throws IOException {
                    return v.longValue();
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    return v.advanceExact(doc);
                }
            };
        }

        @Override
        public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return this.inner.rewrite(searcher).toDoubleValuesSource();
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return this.inner.isCacheable(ctx);
        }

        @Override
        public String toString() {
            return "double(" + this.inner.toString() + ")";
        }

        @Override
        public boolean needsScores() {
            return this.inner.needsScores();
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DoubleLongValuesSource that = (DoubleLongValuesSource)o;
            return Objects.equals(this.inner, that.inner);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.inner);
        }
    }
}

