/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search.suggest.document;

import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.ScoreDoc;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TopDocs;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TotalHits;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.suggest.Lookup;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.suggest.document.SuggestScoreDocPriorityQueue;

public class TopSuggestDocs
extends TopDocs {
    public static final TopSuggestDocs EMPTY = new TopSuggestDocs(new TotalHits(0L, TotalHits.Relation.EQUAL_TO), new SuggestScoreDoc[0]);

    public TopSuggestDocs(TotalHits totalHits, SuggestScoreDoc[] scoreDocs) {
        super(totalHits, scoreDocs);
    }

    public SuggestScoreDoc[] scoreLookupDocs() {
        return (SuggestScoreDoc[])this.scoreDocs;
    }

    public static TopSuggestDocs merge(int topN, TopSuggestDocs[] shardHits) {
        SuggestScoreDocPriorityQueue priorityQueue = new SuggestScoreDocPriorityQueue(topN);
        for (TopSuggestDocs shardHit : shardHits) {
            for (SuggestScoreDoc scoreDoc : shardHit.scoreLookupDocs()) {
                if (scoreDoc == priorityQueue.insertWithOverflow(scoreDoc)) break;
            }
        }
        SuggestScoreDoc[] topNResults = priorityQueue.getResults();
        if (topNResults.length > 0) {
            return new TopSuggestDocs(new TotalHits(topNResults.length, TotalHits.Relation.EQUAL_TO), topNResults);
        }
        return EMPTY;
    }

    public static class SuggestScoreDoc
    extends ScoreDoc
    implements Comparable<SuggestScoreDoc> {
        public final CharSequence key;
        public final CharSequence context;

        public SuggestScoreDoc(int doc, CharSequence key, CharSequence context, float score) {
            super(doc, score);
            this.key = key;
            this.context = context;
        }

        @Override
        public int compareTo(SuggestScoreDoc o) {
            return Lookup.CHARSEQUENCE_COMPARATOR.compare(this.key, o.key);
        }

        public boolean equals(Object other) {
            if (!(other instanceof SuggestScoreDoc)) {
                return false;
            }
            return this.key.equals(((SuggestScoreDoc)other).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        @Override
        public String toString() {
            return "key=" + this.key + " doc=" + this.doc + " score=" + this.score + " shardIndex=" + this.shardIndex;
        }
    }
}

