/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial.spatial4j;

import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial.spatial4j.Geo3dPointShape;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial.spatial4j.Geo3dShape;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoBBox;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoBBoxFactory;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoPoint;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.GeoPointShapeFactory;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial3d.geom.LatLonBounds;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;

public class Geo3dRectangleShape
extends Geo3dShape<GeoBBox>
implements Rectangle {
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;

    public Geo3dRectangleShape(GeoBBox shape, SpatialContext spatialcontext, double minX, double maxX, double minY, double maxY) {
        super(shape, spatialcontext);
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    public Geo3dRectangleShape(GeoBBox shape, SpatialContext spatialcontext) {
        super(shape, spatialcontext);
        this.setBoundsFromshape();
    }

    private void setBoundsFromshape() {
        LatLonBounds bounds = new LatLonBounds();
        ((GeoBBox)this.shape).getBounds(bounds);
        this.minX = bounds.checkNoLongitudeBound() ? -180.0 : bounds.getLeftLongitude() * 57.29577951308232;
        this.minY = bounds.checkNoBottomLatitudeBound() ? -90.0 : bounds.getMinLatitude() * 57.29577951308232;
        this.maxX = bounds.checkNoLongitudeBound() ? 180.0 : bounds.getRightLongitude() * 57.29577951308232;
        this.maxY = bounds.checkNoTopLatitudeBound() ? 90.0 : bounds.getMaxLatitude() * 57.29577951308232;
    }

    @Override
    public Point getCenter() {
        Point center = this.center;
        if (center == null) {
            GeoPoint point = ((GeoBBox)this.shape).getCenter();
            this.center = center = new Geo3dPointShape(GeoPointShapeFactory.makeGeoPointShape(((GeoBBox)this.shape).getPlanetModel(), point.getLatitude(), point.getLongitude()), this.spatialcontext);
        }
        return center;
    }

    public void reset(double minX, double maxX, double minY, double maxY) {
        this.shape = GeoBBoxFactory.makeGeoBBox(((GeoBBox)this.shape).getPlanetModel(), maxY * (Math.PI / 180), minY * (Math.PI / 180), minX * (Math.PI / 180), maxX * (Math.PI / 180));
        this.center = null;
        this.boundingBox = null;
    }

    @Override
    public Rectangle getBoundingBox() {
        return this;
    }

    public double getWidth() {
        double result = this.getMaxX() - this.getMinX();
        if (result < 0.0) {
            result += 360.0;
        }
        return result;
    }

    public double getHeight() {
        return this.getMaxY() - this.getMinY();
    }

    public double getMinX() {
        return this.minX;
    }

    public double getMinY() {
        return this.minY;
    }

    public double getMaxX() {
        return this.maxX;
    }

    public double getMaxY() {
        return this.maxY;
    }

    public boolean getCrossesDateLine() {
        return this.getMaxX() > 0.0 && this.getMinX() < 0.0;
    }

    public SpatialRelation relateYRange(double minY, double maxY) {
        Rectangle r = this.spatialcontext.getShapeFactory().rect(-180.0, 180.0, minY, maxY);
        return this.relate((Shape)r);
    }

    public SpatialRelation relateXRange(double minX, double maxX) {
        Rectangle r = this.spatialcontext.getShapeFactory().rect(minX, maxX, -90.0, 90.0);
        return this.relate((Shape)r);
    }

    @Override
    public Shape getBuffered(double distance, SpatialContext spatialContext) {
        GeoBBox bBox = ((GeoBBox)this.shape).expand(distance * (Math.PI / 180));
        return new Geo3dRectangleShape(bBox, spatialContext);
    }
}

