/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.util.bkd;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.codecs.CodecUtil;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.Directory;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.IOContext;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.store.IndexOutput;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.bkd.OfflinePointReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.bkd.PointReader;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.bkd.PointValue;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.bkd.PointWriter;

public final class OfflinePointWriter
implements PointWriter {
    final Directory tempDir;
    public final IndexOutput out;
    public final String name;
    final int packedBytesLength;
    long count;
    private boolean closed;
    final long expectedCount;

    public OfflinePointWriter(Directory tempDir, String tempFileNamePrefix, int packedBytesLength, String desc, long expectedCount) throws IOException {
        this.out = tempDir.createTempOutput(tempFileNamePrefix, "bkd_" + desc, IOContext.DEFAULT);
        this.name = this.out.getName();
        this.tempDir = tempDir;
        this.packedBytesLength = packedBytesLength;
        this.expectedCount = expectedCount;
    }

    @Override
    public void append(byte[] packedValue, int docID) throws IOException {
        assert (!this.closed) : "Point writer is already closed";
        assert (packedValue.length == this.packedBytesLength) : "[packedValue] must have length [" + this.packedBytesLength + "] but was [" + packedValue.length + "]";
        this.out.writeBytes(packedValue, 0, packedValue.length);
        this.out.writeInt(docID);
        ++this.count;
        assert (this.expectedCount == 0L || this.count <= this.expectedCount) : "expectedCount=" + this.expectedCount + " vs count=" + this.count;
    }

    @Override
    public void append(PointValue pointValue) throws IOException {
        assert (!this.closed) : "Point writer is already closed";
        BytesRef packedValueDocID = pointValue.packedValueDocIDBytes();
        assert (packedValueDocID.length == this.packedBytesLength + 4) : "[packedValue and docID] must have length [" + (this.packedBytesLength + 4) + "] but was [" + packedValueDocID.length + "]";
        this.out.writeBytes(packedValueDocID.bytes, packedValueDocID.offset, packedValueDocID.length);
        ++this.count;
        assert (this.expectedCount == 0L || this.count <= this.expectedCount) : "expectedCount=" + this.expectedCount + " vs count=" + this.count;
    }

    @Override
    public PointReader getReader(long start, long length) throws IOException {
        byte[] buffer = new byte[this.packedBytesLength + 4];
        return this.getReader(start, length, buffer);
    }

    protected OfflinePointReader getReader(long start, long length, byte[] reusableBuffer) throws IOException {
        assert (this.closed) : "point writer is still open and trying to get a reader";
        assert (start + length <= this.count) : "start=" + start + " length=" + length + " count=" + this.count;
        assert (this.expectedCount == 0L || this.count == this.expectedCount);
        return new OfflinePointReader(this.tempDir, this.name, this.packedBytesLength, start, length, reusableBuffer);
    }

    @Override
    public long count() {
        return this.count;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try {
                CodecUtil.writeFooter(this.out);
            }
            finally {
                this.out.close();
                this.closed = true;
            }
        }
    }

    @Override
    public void destroy() throws IOException {
        this.tempDir.deleteFile(this.name);
    }

    public String toString() {
        return "OfflinePointWriter(count=" + this.count + " tempFileName=" + this.name + ")";
    }
}

