/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.exists.indices;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequestValidationException;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.IndicesRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ValidateActions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;

public class IndicesExistsRequest
extends MasterNodeReadRequest<IndicesExistsRequest>
implements IndicesRequest.Replaceable {
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, false, true, true);

    public IndicesExistsRequest() {
    }

    public IndicesExistsRequest(String ... indices) {
        this.indices = indices;
    }

    public IndicesExistsRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesExistsRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public IndicesExistsRequest expandWilcardsOpen(boolean expandWildcardsOpen) {
        this.indicesOptions = IndicesOptions.fromOptions(this.indicesOptions.ignoreUnavailable(), this.indicesOptions.allowNoIndices(), expandWildcardsOpen, this.indicesOptions.expandWildcardsClosed());
        return this;
    }

    public IndicesExistsRequest expandWilcardsClosed(boolean expandWildcardsClosed) {
        this.indicesOptions = IndicesOptions.fromOptions(this.indicesOptions.ignoreUnavailable(), this.indicesOptions.allowNoIndices(), this.indicesOptions.expandWildcardsOpen(), expandWildcardsClosed);
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indices == null || this.indices.length == 0) {
            validationException = ValidateActions.addValidationError("index/indices is missing", validationException);
        }
        return validationException;
    }
}

