/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ingest;

import java.util.Map;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ingest.SimulateExecutionService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ingest.SimulatePipelineRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ingest.SimulatePipelineResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.ActionFilters;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.HandledTransportAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentHelper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.ingest.IngestService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.tasks.Task;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportService;

public class SimulatePipelineTransportAction
extends HandledTransportAction<SimulatePipelineRequest, SimulatePipelineResponse> {
    private final IngestService ingestService;
    private final SimulateExecutionService executionService;

    @Inject
    public SimulatePipelineTransportAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IngestService ingestService) {
        super("cluster:admin/ingest/pipeline/simulate", transportService, actionFilters, SimulatePipelineRequest::new);
        this.ingestService = ingestService;
        this.executionService = new SimulateExecutionService(threadPool);
    }

    @Override
    protected void doExecute(Task task, SimulatePipelineRequest request, ActionListener<SimulatePipelineResponse> listener) {
        SimulatePipelineRequest.Parsed simulateRequest;
        Map<String, Object> source = XContentHelper.convertToMap(request.getSource(), false, request.getXContentType()).v2();
        try {
            simulateRequest = request.getId() != null ? SimulatePipelineRequest.parseWithPipelineId(request.getId(), source, request.isVerbose(), this.ingestService) : SimulatePipelineRequest.parse(source, request.isVerbose(), this.ingestService);
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        this.executionService.execute(simulateRequest, listener);
    }
}

