/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.datafeed;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;

public class DelayedDataCheckConfig
implements ToXContentObject {
    public static final ParseField ENABLED = new ParseField("enabled", new String[0]);
    public static final ParseField CHECK_WINDOW = new ParseField("check_window", new String[0]);
    public static final ConstructingObjectParser<DelayedDataCheckConfig, Void> PARSER = new ConstructingObjectParser("delayed_data_check_config", true, a -> new DelayedDataCheckConfig((Boolean)a[0], (TimeValue)a[1]));
    private final boolean enabled;
    private final TimeValue checkWindow;

    public static DelayedDataCheckConfig enabledDelayedDataCheckConfig(TimeValue timeValue) {
        return new DelayedDataCheckConfig(true, timeValue);
    }

    public static DelayedDataCheckConfig disabledDelayedDataCheckConfig() {
        return new DelayedDataCheckConfig(false, null);
    }

    DelayedDataCheckConfig(Boolean enabled, TimeValue checkWindow) {
        this.enabled = enabled;
        this.checkWindow = checkWindow;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public TimeValue getCheckWindow() {
        return this.checkWindow;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ENABLED.getPreferredName(), this.enabled);
        if (this.checkWindow != null) {
            builder.field(CHECK_WINDOW.getPreferredName(), this.checkWindow.getStringRep());
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.checkWindow);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DelayedDataCheckConfig other = (DelayedDataCheckConfig)obj;
        return Objects.equals(this.enabled, other.enabled) && Objects.equals(this.checkWindow, other.checkWindow);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ENABLED);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), text -> TimeValue.parseTimeValue(text, CHECK_WINDOW.getPreferredName()), CHECK_WINDOW);
    }
}

