/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.dataframe.evaluation.softclassification;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.dataframe.evaluation.EvaluationMetric;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.dataframe.evaluation.softclassification.AbstractConfusionMatrixMetric;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Strings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;

public class PrecisionMetric
extends AbstractConfusionMatrixMetric {
    public static final String NAME = "precision";
    private static final ConstructingObjectParser<PrecisionMetric, Void> PARSER = new ConstructingObjectParser("precision", args -> new PrecisionMetric((List)args[0]));

    public static PrecisionMetric fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public static PrecisionMetric at(Double ... at) {
        return new PrecisionMetric(Arrays.asList(at));
    }

    public PrecisionMetric(List<Double> at) {
        super(at);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrecisionMetric that = (PrecisionMetric)o;
        return Arrays.equals(this.thresholds, that.thresholds);
    }

    public int hashCode() {
        return Arrays.hashCode(this.thresholds);
    }

    static {
        PARSER.declareDoubleArray(ConstructingObjectParser.constructorArg(), AT);
    }

    public static class Result
    implements EvaluationMetric.Result {
        private final Map<String, Double> results;

        public static Result fromXContent(XContentParser parser) throws IOException {
            return new Result(parser.map(LinkedHashMap::new, p -> p.doubleValue()));
        }

        public Result(Map<String, Double> results) {
            this.results = Objects.requireNonNull(results);
        }

        @Override
        public String getMetricName() {
            return PrecisionMetric.NAME;
        }

        public Double getScoreByThreshold(String threshold) {
            return this.results.get(threshold);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.map(this.results);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result that = (Result)o;
            return Objects.equals(this.results, that.results);
        }

        public int hashCode() {
            return Objects.hash(this.results);
        }

        public String toString() {
            return Strings.toString(this);
        }
    }
}

