/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.dataframe.stats.classification;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.common.TimeUtil;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.dataframe.stats.AnalysisStats;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.dataframe.stats.classification.Hyperparameters;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.dataframe.stats.classification.TimingStats;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.dataframe.stats.classification.ValidationLoss;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;

public class ClassificationStats
implements AnalysisStats {
    public static final ParseField NAME = new ParseField("classification_stats", new String[0]);
    public static final ParseField TIMESTAMP = new ParseField("timestamp", new String[0]);
    public static final ParseField ITERATION = new ParseField("iteration", new String[0]);
    public static final ParseField HYPERPARAMETERS = new ParseField("hyperparameters", new String[0]);
    public static final ParseField TIMING_STATS = new ParseField("timing_stats", new String[0]);
    public static final ParseField VALIDATION_LOSS = new ParseField("validation_loss", new String[0]);
    public static final ConstructingObjectParser<ClassificationStats, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), true, a -> new ClassificationStats((Instant)a[0], (Integer)a[1], (Hyperparameters)a[2], (TimingStats)a[3], (ValidationLoss)a[4]));
    private final Instant timestamp;
    private final Integer iteration;
    private final Hyperparameters hyperparameters;
    private final TimingStats timingStats;
    private final ValidationLoss validationLoss;

    public ClassificationStats(Instant timestamp, Integer iteration, Hyperparameters hyperparameters, TimingStats timingStats, ValidationLoss validationLoss) {
        this.timestamp = Instant.ofEpochMilli(Objects.requireNonNull(timestamp).toEpochMilli());
        this.iteration = iteration;
        this.hyperparameters = Objects.requireNonNull(hyperparameters);
        this.timingStats = Objects.requireNonNull(timingStats);
        this.validationLoss = Objects.requireNonNull(validationLoss);
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Integer getIteration() {
        return this.iteration;
    }

    public Hyperparameters getHyperparameters() {
        return this.hyperparameters;
    }

    public TimingStats getTimingStats() {
        return this.timingStats;
    }

    public ValidationLoss getValidationLoss() {
        return this.validationLoss;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.timeField(TIMESTAMP.getPreferredName(), TIMESTAMP.getPreferredName() + "_string", this.timestamp.toEpochMilli());
        if (this.iteration != null) {
            builder.field(ITERATION.getPreferredName(), this.iteration);
        }
        builder.field(HYPERPARAMETERS.getPreferredName(), this.hyperparameters);
        builder.field(TIMING_STATS.getPreferredName(), this.timingStats);
        builder.field(VALIDATION_LOSS.getPreferredName(), this.validationLoss);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassificationStats that = (ClassificationStats)o;
        return Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.iteration, that.iteration) && Objects.equals(this.hyperparameters, that.hyperparameters) && Objects.equals(this.timingStats, that.timingStats) && Objects.equals(this.validationLoss, that.validationLoss);
    }

    public int hashCode() {
        return Objects.hash(this.timestamp, this.iteration, this.hyperparameters, this.timingStats, this.validationLoss);
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> TimeUtil.parseTimeFieldToInstant(p, TIMESTAMP.getPreferredName()), TIMESTAMP, ObjectParser.ValueType.VALUE);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), ITERATION);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), Hyperparameters.PARSER, HYPERPARAMETERS);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), TimingStats.PARSER, TIMING_STATS);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), ValidationLoss.PARSER, VALIDATION_LOSS);
    }
}

