/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.ml.job.config;

import java.io.IOException;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;

public class ModelPlotConfig
implements ToXContentObject {
    private static final ParseField TYPE_FIELD = new ParseField("model_plot_config", new String[0]);
    private static final ParseField ENABLED_FIELD = new ParseField("enabled", new String[0]);
    private static final ParseField TERMS_FIELD = new ParseField("terms", new String[0]);
    private static final ParseField ANNOTATIONS_ENABLED_FIELD = new ParseField("annotations_enabled", new String[0]);
    public static final ConstructingObjectParser<ModelPlotConfig, Void> PARSER = new ConstructingObjectParser(TYPE_FIELD.getPreferredName(), true, a -> new ModelPlotConfig((Boolean)a[0], (String)a[1], (Boolean)a[2]));
    private final boolean enabled;
    private final String terms;
    private final Boolean annotationsEnabled;

    public ModelPlotConfig(boolean enabled, String terms, Boolean annotationsEnabled) {
        this.enabled = enabled;
        this.terms = terms;
        this.annotationsEnabled = annotationsEnabled;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ENABLED_FIELD.getPreferredName(), this.enabled);
        if (this.terms != null) {
            builder.field(TERMS_FIELD.getPreferredName(), this.terms);
        }
        if (this.annotationsEnabled != null) {
            builder.field(ANNOTATIONS_ENABLED_FIELD.getPreferredName(), this.annotationsEnabled);
        }
        builder.endObject();
        return builder;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getTerms() {
        return this.terms;
    }

    public Boolean annotationsEnabled() {
        return this.annotationsEnabled;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModelPlotConfig)) {
            return false;
        }
        ModelPlotConfig that = (ModelPlotConfig)other;
        return this.enabled == that.enabled && Objects.equals(this.terms, that.terms) && Objects.equals(this.annotationsEnabled, that.annotationsEnabled);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.terms, this.annotationsEnabled);
    }

    static {
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), ENABLED_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), TERMS_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), ANNOTATIONS_ENABLED_FIELD);
    }
}

