/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.client.security;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.SecureString;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;

public final class CreateApiKeyResponse {
    private final String name;
    private final String id;
    private final SecureString key;
    private final Instant expiration;
    static final ConstructingObjectParser<CreateApiKeyResponse, Void> PARSER = new ConstructingObjectParser("create_api_key_response", args -> new CreateApiKeyResponse((String)args[0], (String)args[1], new SecureString((String)args[2]), args[3] == null ? null : Instant.ofEpochMilli((Long)args[3])));

    public CreateApiKeyResponse(String name, String id, SecureString key, Instant expiration) {
        this.name = name;
        this.id = id;
        this.key = key;
        this.expiration = expiration != null ? Instant.ofEpochMilli(expiration.toEpochMilli()) : null;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public SecureString getKey() {
        return this.key;
    }

    @Nullable
    public Instant getExpiration() {
        return this.expiration;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.key, this.expiration);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CreateApiKeyResponse other = (CreateApiKeyResponse)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.key, other.key) && Objects.equals(this.name, other.name) && Objects.equals(this.expiration, other.expiration);
    }

    public static CreateApiKeyResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("name", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("id", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("api_key", new String[0]));
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), new ParseField("expiration", new String[0]));
    }
}

