/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.action.index;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.IndicesRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.metadata.MetadataMappingService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.tasks.Task;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.EmptyTransportResponseHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportChannel;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportRequestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportService;

public class NodeMappingRefreshAction {
    private static final Logger logger = LogManager.getLogger(NodeMappingRefreshAction.class);
    public static final String ACTION_NAME = "internal:cluster/node/mapping/refresh";
    private final TransportService transportService;
    private final MetadataMappingService metadataMappingService;

    @Inject
    public NodeMappingRefreshAction(TransportService transportService, MetadataMappingService metadataMappingService) {
        this.transportService = transportService;
        this.metadataMappingService = metadataMappingService;
        transportService.registerRequestHandler(ACTION_NAME, "same", NodeMappingRefreshRequest::new, new NodeMappingRefreshTransportHandler());
    }

    public void nodeMappingRefresh(DiscoveryNode masterNode, NodeMappingRefreshRequest request) {
        if (masterNode == null) {
            logger.warn("can't send mapping refresh for [{}], no master known.", (Object)request.index());
            return;
        }
        this.transportService.sendRequest(masterNode, ACTION_NAME, request, EmptyTransportResponseHandler.INSTANCE_SAME);
    }

    private class NodeMappingRefreshTransportHandler
    implements TransportRequestHandler<NodeMappingRefreshRequest> {
        private NodeMappingRefreshTransportHandler() {
        }

        @Override
        public void messageReceived(NodeMappingRefreshRequest request, TransportChannel channel, Task task) throws Exception {
            NodeMappingRefreshAction.this.metadataMappingService.refreshMapping(request.index(), request.indexUUID());
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    public static class NodeMappingRefreshRequest
    extends TransportRequest
    implements IndicesRequest {
        private String index;
        private String indexUUID = "_na_";
        private String nodeId;

        public NodeMappingRefreshRequest(StreamInput in) throws IOException {
            super(in);
            this.index = in.readString();
            this.nodeId = in.readString();
            this.indexUUID = in.readString();
        }

        public NodeMappingRefreshRequest(String index, String indexUUID, String nodeId) {
            this.index = index;
            this.indexUUID = indexUUID;
            this.nodeId = nodeId;
        }

        @Override
        public String[] indices() {
            return new String[]{this.index};
        }

        @Override
        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        }

        public String index() {
            return this.index;
        }

        public String indexUUID() {
            return this.indexUUID;
        }

        public String nodeId() {
            return this.nodeId;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.index);
            out.writeString(this.nodeId);
            out.writeString(this.indexUUID);
        }
    }
}

