/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.common.transport;

import java.util.StringTokenizer;
import org.graylog.shaded.elasticsearch7.com.carrotsearch.hppc.IntArrayList;

public class PortsRange {
    private final String portRange;

    public PortsRange(String portRange) {
        this.portRange = portRange;
    }

    public String getPortRangeString() {
        return this.portRange;
    }

    public int[] ports() throws NumberFormatException {
        final IntArrayList ports = new IntArrayList();
        this.iterate(new PortCallback(){

            @Override
            public boolean onPortNumber(int portNumber) {
                ports.add(portNumber);
                return false;
            }
        });
        return ports.toArray();
    }

    public boolean iterate(PortCallback callback) throws NumberFormatException {
        StringTokenizer st = new StringTokenizer(this.portRange, ",");
        boolean success = false;
        while (st.hasMoreTokens() && !success) {
            String portToken = st.nextToken().trim();
            int index = portToken.indexOf(45);
            if (index == -1) {
                int portNumber = Integer.parseInt(portToken.trim());
                success = callback.onPortNumber(portNumber);
                if (!success) continue;
                break;
            }
            int startPort = Integer.parseInt(portToken.substring(0, index).trim());
            int endPort = Integer.parseInt(portToken.substring(index + 1).trim());
            if (endPort < startPort) {
                throw new IllegalArgumentException("Start port [" + startPort + "] must be greater than end port [" + endPort + "]");
            }
            for (int i = startPort; i <= endPort && !(success = callback.onPortNumber(i)); ++i) {
            }
        }
        return success;
    }

    public String toString() {
        return "PortsRange{portRange='" + this.portRange + '\'' + '}';
    }

    public static interface PortCallback {
        public boolean onPortNumber(int var1);
    }
}

