/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.document.LatLonShape;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.IndexableField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.geo.GeoLineDecomposer;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.geo.GeoPolygonDecomposer;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.geo.GeoShapeType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.geo.GeoShapeUtils;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.geo.GeoUtils;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.geometry.Circle;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.geometry.Geometry;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.geometry.GeometryCollection;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.geometry.GeometryVisitor;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.geometry.Line;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.geometry.LinearRing;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.geometry.MultiLine;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.geometry.MultiPoint;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.geometry.MultiPolygon;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.geometry.Point;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.geometry.Polygon;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.geometry.Rectangle;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.ParseContext;

public class GeoShapeIndexer
implements AbstractGeometryFieldMapper.Indexer<Geometry, Geometry> {
    private final boolean orientation;
    private final String name;

    public GeoShapeIndexer(boolean orientation, String name) {
        this.orientation = orientation;
        this.name = name;
    }

    @Override
    public Geometry prepareForIndexing(Geometry geometry) {
        if (geometry == null) {
            return null;
        }
        return geometry.visit(new GeometryVisitor<Geometry, RuntimeException>(){

            @Override
            public Geometry visit(Circle circle) {
                throw new UnsupportedOperationException((Object)((Object)GeoShapeType.CIRCLE) + " geometry is not supported");
            }

            @Override
            public Geometry visit(GeometryCollection<?> collection) {
                if (collection.isEmpty()) {
                    return GeometryCollection.EMPTY;
                }
                ArrayList<Geometry> shapes = new ArrayList<Geometry>(collection.size());
                for (Geometry shape : collection) {
                    shapes.add(shape.visit(this));
                }
                if (shapes.size() == 1) {
                    return (Geometry)shapes.get(0);
                }
                return new GeometryCollection(shapes);
            }

            @Override
            public Geometry visit(Line line) {
                ArrayList<Line> lines = new ArrayList<Line>();
                GeoLineDecomposer.decomposeLine(line, lines);
                if (lines.isEmpty()) {
                    return GeometryCollection.EMPTY;
                }
                if (lines.size() == 1) {
                    return (Geometry)lines.get(0);
                }
                return new MultiLine((List<Line>)lines);
            }

            @Override
            public Geometry visit(LinearRing ring) {
                throw new UnsupportedOperationException("cannot index linear ring [" + ring + "] directly");
            }

            @Override
            public Geometry visit(MultiLine multiLine) {
                ArrayList<Line> lines = new ArrayList<Line>();
                GeoLineDecomposer.decomposeMultiLine(multiLine, lines);
                if (lines.isEmpty()) {
                    return GeometryCollection.EMPTY;
                }
                if (lines.size() == 1) {
                    return (Geometry)lines.get(0);
                }
                return new MultiLine((List<Line>)lines);
            }

            @Override
            public Geometry visit(MultiPoint multiPoint) {
                if (multiPoint.isEmpty()) {
                    return MultiPoint.EMPTY;
                }
                if (multiPoint.size() == 1) {
                    return ((Point)multiPoint.get(0)).visit(this);
                }
                ArrayList<Point> points = new ArrayList<Point>();
                for (Point point : multiPoint) {
                    points.add((Point)point.visit(this));
                }
                return new MultiPoint((List<Point>)points);
            }

            @Override
            public Geometry visit(MultiPolygon multiPolygon) {
                ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                GeoPolygonDecomposer.decomposeMultiPolygon(multiPolygon, GeoShapeIndexer.this.orientation, polygons);
                if (polygons.isEmpty()) {
                    return GeometryCollection.EMPTY;
                }
                if (polygons.size() == 1) {
                    return (Geometry)polygons.get(0);
                }
                return new MultiPolygon((List<Polygon>)polygons);
            }

            @Override
            public Geometry visit(Point point) {
                double[] latlon = new double[]{point.getX(), point.getY()};
                GeoUtils.normalizePoint(latlon);
                return new Point(latlon[0], latlon[1]);
            }

            @Override
            public Geometry visit(Polygon polygon) {
                ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                GeoPolygonDecomposer.decomposePolygon(polygon, GeoShapeIndexer.this.orientation, polygons);
                if (polygons.isEmpty()) {
                    return GeometryCollection.EMPTY;
                }
                if (polygons.size() == 1) {
                    return (Geometry)polygons.get(0);
                }
                return new MultiPolygon((List<Polygon>)polygons);
            }

            @Override
            public Geometry visit(Rectangle rectangle) {
                return rectangle;
            }
        });
    }

    @Override
    public Class<Geometry> processedClass() {
        return Geometry.class;
    }

    @Override
    public List<IndexableField> indexShape(ParseContext context, Geometry shape) {
        LuceneGeometryIndexer visitor = new LuceneGeometryIndexer(this.name);
        shape.visit(visitor);
        return visitor.fields();
    }

    private static class LuceneGeometryIndexer
    implements GeometryVisitor<Void, RuntimeException> {
        private List<IndexableField> fields = new ArrayList<IndexableField>();
        private final String name;

        private LuceneGeometryIndexer(String name) {
            this.name = name;
        }

        List<IndexableField> fields() {
            return this.fields;
        }

        @Override
        public Void visit(Circle circle) {
            throw new IllegalArgumentException("invalid shape type found [Circle] while indexing shape");
        }

        @Override
        public Void visit(GeometryCollection<?> collection) {
            for (Geometry geometry : collection) {
                geometry.visit(this);
            }
            return null;
        }

        @Override
        public Void visit(Line line) {
            this.addFields(LatLonShape.createIndexableFields(this.name, GeoShapeUtils.toLuceneLine(line)));
            return null;
        }

        @Override
        public Void visit(LinearRing ring) {
            throw new IllegalArgumentException("invalid shape type found [LinearRing] while indexing shape");
        }

        @Override
        public Void visit(MultiLine multiLine) {
            for (Line line : multiLine) {
                this.visit(line);
            }
            return null;
        }

        @Override
        public Void visit(MultiPoint multiPoint) {
            for (Point point : multiPoint) {
                this.visit(point);
            }
            return null;
        }

        @Override
        public Void visit(MultiPolygon multiPolygon) {
            for (Polygon polygon : multiPolygon) {
                this.visit(polygon);
            }
            return null;
        }

        @Override
        public Void visit(Point point) {
            this.addFields(LatLonShape.createIndexableFields(this.name, point.getY(), point.getX()));
            return null;
        }

        @Override
        public Void visit(Polygon polygon) {
            this.addFields(LatLonShape.createIndexableFields(this.name, GeoShapeUtils.toLucenePolygon(polygon)));
            return null;
        }

        @Override
        public Void visit(Rectangle r) {
            if (r.getMinLon() > r.getMaxLon()) {
                Rectangle left = new Rectangle(r.getMinLon(), 180.0, r.getMaxLat(), r.getMinLat());
                this.addFields(LatLonShape.createIndexableFields(this.name, GeoShapeUtils.toLucenePolygon(left)));
                Rectangle right = new Rectangle(-180.0, r.getMaxLon(), r.getMaxLat(), r.getMinLat());
                this.addFields(LatLonShape.createIndexableFields(this.name, GeoShapeUtils.toLucenePolygon(right)));
            } else {
                this.addFields(LatLonShape.createIndexableFields(this.name, GeoShapeUtils.toLucenePolygon(r)));
            }
            return null;
        }

        private void addFields(IndexableField[] fields) {
            this.fields.addAll(Arrays.asList(fields));
        }
    }
}

