/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.persistent;

import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.Nullable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.persistent.AllocatedPersistentTask;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.persistent.PersistentTaskParams;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.persistent.PersistentTaskState;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.persistent.PersistentTasksExecutor;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.threadpool.ThreadPool;

public class NodePersistentTasksExecutor {
    private final ThreadPool threadPool;

    NodePersistentTasksExecutor(ThreadPool threadPool) {
        this.threadPool = threadPool;
    }

    public <Params extends PersistentTaskParams> void executeTask(final Params params, final @Nullable PersistentTaskState state, final AllocatedPersistentTask task, final PersistentTasksExecutor<Params> executor) {
        this.threadPool.executor(executor.getExecutor()).execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
                task.markAsFailed(e);
            }

            @Override
            protected void doRun() throws Exception {
                try {
                    executor.nodeOperation(task, params, state);
                }
                catch (Exception ex) {
                    task.markAsFailed(ex);
                }
            }
        });
    }
}

