/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.admin.indices.analyze.AnalyzeAction;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.node.NodeClient;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.BaseRestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestChannel;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.RestRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.rest.action.RestToXContentListener;

public class RestAnalyzeAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_analyze"), new RestHandler.Route(RestRequest.Method.POST, "/_analyze"), new RestHandler.Route(RestRequest.Method.GET, "/{index}/_analyze"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_analyze")));
    }

    @Override
    public String getName() {
        return "analyze_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentOrSourceParamParser();){
            AnalyzeAction.Request analyzeRequest = AnalyzeAction.Request.fromXContent(parser, request.param("index"));
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.admin().indices().analyze(analyzeRequest, new RestToXContentListener<AnalyzeAction.Response>((RestChannel)channel));
            return restChannelConsumer;
        }
    }

    public static class Fields {
        public static final ParseField ANALYZER = new ParseField("analyzer", new String[0]);
        public static final ParseField TEXT = new ParseField("text", new String[0]);
        public static final ParseField FIELD = new ParseField("field", new String[0]);
        public static final ParseField TOKENIZER = new ParseField("tokenizer", new String[0]);
        public static final ParseField TOKEN_FILTERS = new ParseField("filter", new String[0]);
        public static final ParseField CHAR_FILTERS = new ParseField("char_filter", new String[0]);
        public static final ParseField EXPLAIN = new ParseField("explain", new String[0]);
        public static final ParseField ATTRIBUTES = new ParseField("attributes", new String[0]);
        public static final ParseField NORMALIZER = new ParseField("normalizer", new String[0]);
    }
}

