/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.script;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.ClusterSettings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.IntervalFilterScript;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.plugins.ScriptPlugin;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.AggregationScript;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.BucketAggregationScript;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.BucketAggregationSelectorScript;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.FieldScript;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.FilterScript;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.IngestConditionalScript;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.IngestScript;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.NumberSortScript;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.ScoreScript;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.ScriptContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.ScriptEngine;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.ScriptService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.ScriptedMetricAggContexts;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.SignificantTermsHeuristicScoreScript;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.SimilarityScript;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.SimilarityWeightScript;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.StringSortScript;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.TemplateScript;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.TermsSetQueryScript;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.script.UpdateScript;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.pipeline.MovingFunctionScript;

public class ScriptModule {
    public static final Map<String, ScriptContext<?>> CORE_CONTEXTS = Stream.of(FieldScript.CONTEXT, AggregationScript.CONTEXT, ScoreScript.CONTEXT, NumberSortScript.CONTEXT, StringSortScript.CONTEXT, TermsSetQueryScript.CONTEXT, UpdateScript.CONTEXT, BucketAggregationScript.CONTEXT, BucketAggregationSelectorScript.CONTEXT, SignificantTermsHeuristicScoreScript.CONTEXT, IngestScript.CONTEXT, IngestConditionalScript.CONTEXT, FilterScript.CONTEXT, SimilarityScript.CONTEXT, SimilarityWeightScript.CONTEXT, TemplateScript.CONTEXT, MovingFunctionScript.CONTEXT, ScriptedMetricAggContexts.InitScript.CONTEXT, ScriptedMetricAggContexts.MapScript.CONTEXT, ScriptedMetricAggContexts.CombineScript.CONTEXT, ScriptedMetricAggContexts.ReduceScript.CONTEXT, IntervalFilterScript.CONTEXT).collect(Collectors.toMap(c -> c.name, Function.identity()));
    public final Map<String, ScriptEngine> engines;
    public final Map<String, ScriptContext<?>> contexts;

    public ScriptModule(Settings settings, List<ScriptPlugin> scriptPlugins) {
        HashMap<String, ScriptEngine> engines = new HashMap<String, ScriptEngine>();
        HashMap contexts = new HashMap(CORE_CONTEXTS);
        for (ScriptPlugin plugin : scriptPlugins) {
            for (ScriptContext<?> context : plugin.getContexts()) {
                ScriptContext<?> oldContext = contexts.put(context.name, context);
                if (oldContext == null) continue;
                throw new IllegalArgumentException("Context name [" + context.name + "] defined twice");
            }
        }
        for (ScriptPlugin plugin : scriptPlugins) {
            ScriptEngine existing;
            ScriptEngine engine = plugin.getScriptEngine(settings, contexts.values());
            if (engine == null || (existing = engines.put(engine.getType(), engine)) == null) continue;
            throw new IllegalArgumentException("scripting language [" + engine.getType() + "] defined for engine [" + existing.getClass().getName() + "] and [" + engine.getClass().getName());
        }
        this.engines = Collections.unmodifiableMap(engines);
        this.contexts = Collections.unmodifiableMap(contexts);
    }

    public void registerClusterSettingsListeners(ScriptService scriptService, ClusterSettings clusterSettings) {
        scriptService.registerClusterSettingsListeners(clusterSettings);
    }
}

