/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.highlight.DefaultEncoder;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.highlight.Encoder;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.fieldvisitor.CustomFieldsVisitor;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.MappedFieldType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.mapper.TextSearchInfo;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryShardContext;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.FetchSubPhase;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.lookup.SourceLookup;

public final class HighlightUtils {
    public static final char PARAGRAPH_SEPARATOR = '\u2029';
    public static final char NULL_SEPARATOR = '\u0000';

    private HighlightUtils() {
    }

    public static List<Object> loadFieldValues(MappedFieldType fieldType, QueryShardContext context, FetchSubPhase.HitContext hitContext, boolean forceSource) throws IOException {
        List<Object> textsToHighlight;
        TextSearchInfo tsi = fieldType.getTextSearchInfo();
        if (!forceSource && tsi.isStored()) {
            CustomFieldsVisitor fieldVisitor = new CustomFieldsVisitor(Collections.singleton(fieldType.name()), false);
            hitContext.reader().document(hitContext.docId(), fieldVisitor);
            textsToHighlight = fieldVisitor.fields().get(fieldType.name());
            if (textsToHighlight == null) {
                textsToHighlight = Collections.emptyList();
            }
        } else {
            SourceLookup sourceLookup = context.lookup().source();
            sourceLookup.setSegmentAndDocument(hitContext.readerContext(), hitContext.docId());
            textsToHighlight = sourceLookup.extractRawValues(fieldType.name());
        }
        assert (textsToHighlight != null);
        return textsToHighlight;
    }

    public static class Encoders {
        public static final Encoder DEFAULT = new DefaultEncoder();
        public static final Encoder HTML = new SimpleHTMLEncoder();
    }
}

