/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.search.profile;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.Version;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.ParseField;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.collect.Map;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamInput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.StreamOutput;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.io.stream.Writeable;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.unit.TimeValue;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.InstantiatingObjectParser;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContent;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.ToXContentObject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.xcontent.XContentParser;

public final class ProfileResult
implements Writeable,
ToXContentObject {
    static final ParseField TYPE = new ParseField("type", new String[0]);
    static final ParseField DESCRIPTION = new ParseField("description", new String[0]);
    static final ParseField BREAKDOWN = new ParseField("breakdown", new String[0]);
    static final ParseField DEBUG = new ParseField("debug", new String[0]);
    static final ParseField NODE_TIME = new ParseField("time", new String[0]);
    static final ParseField NODE_TIME_RAW = new ParseField("time_in_nanos", new String[0]);
    static final ParseField CHILDREN = new ParseField("children", new String[0]);
    private final String type;
    private final String description;
    private final java.util.Map<String, Long> breakdown;
    private final java.util.Map<String, Object> debug;
    private final long nodeTime;
    private final List<ProfileResult> children;
    private static final InstantiatingObjectParser<ProfileResult, Void> PARSER;

    public ProfileResult(String type, String description, java.util.Map<String, Long> breakdown, java.util.Map<String, Object> debug, long nodeTime, List<ProfileResult> children) {
        this.type = type;
        this.description = description;
        this.breakdown = Objects.requireNonNull(breakdown, "required breakdown argument missing");
        this.debug = debug == null ? Map.of() : debug;
        this.children = children == null ? org.graylog.shaded.elasticsearch7.org.elasticsearch.common.collect.List.of() : children;
        this.nodeTime = nodeTime;
    }

    public ProfileResult(StreamInput in) throws IOException {
        this.type = in.readString();
        this.description = in.readString();
        this.nodeTime = in.readLong();
        this.breakdown = in.readMap(StreamInput::readString, StreamInput::readLong);
        this.debug = in.getVersion().onOrAfter(Version.V_7_9_0) ? in.readMap(StreamInput::readString, StreamInput::readGenericValue) : Map.of();
        this.children = in.readList(ProfileResult::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        out.writeString(this.description);
        out.writeLong(this.nodeTime);
        out.writeMap(this.breakdown, StreamOutput::writeString, StreamOutput::writeLong);
        if (out.getVersion().onOrAfter(Version.V_7_9_0)) {
            out.writeMap(this.debug, StreamOutput::writeString, StreamOutput::writeGenericValue);
        }
        out.writeList(this.children);
    }

    public String getLuceneDescription() {
        return this.description;
    }

    public String getQueryName() {
        return this.type;
    }

    public java.util.Map<String, Long> getTimeBreakdown() {
        return Collections.unmodifiableMap(this.breakdown);
    }

    public java.util.Map<String, Object> getDebugInfo() {
        return Collections.unmodifiableMap(this.debug);
    }

    public long getTime() {
        return this.nodeTime;
    }

    public List<ProfileResult> getProfiledChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TYPE.getPreferredName(), this.type);
        builder.field(DESCRIPTION.getPreferredName(), this.description);
        if (builder.humanReadable()) {
            builder.field(NODE_TIME.getPreferredName(), new TimeValue(this.getTime(), TimeUnit.NANOSECONDS).toString());
        }
        builder.field(NODE_TIME_RAW.getPreferredName(), this.getTime());
        builder.field(BREAKDOWN.getPreferredName(), this.breakdown);
        if (!this.debug.isEmpty()) {
            builder.field(DEBUG.getPreferredName(), this.debug);
        }
        if (!this.children.isEmpty()) {
            builder.startArray(CHILDREN.getPreferredName());
            for (ProfileResult child : this.children) {
                builder = child.toXContent(builder, params);
            }
            builder.endArray();
        }
        return builder.endObject();
    }

    public static ProfileResult fromXContent(XContentParser p) throws IOException {
        return PARSER.parse(p, null);
    }

    static {
        InstantiatingObjectParser.Builder<ProfileResult, Void> parser = InstantiatingObjectParser.builder("profile_result", true, ProfileResult.class);
        parser.declareString(ConstructingObjectParser.constructorArg(), TYPE);
        parser.declareString(ConstructingObjectParser.constructorArg(), DESCRIPTION);
        parser.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> p.map(), BREAKDOWN);
        parser.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), DEBUG);
        parser.declareLong(ConstructingObjectParser.constructorArg(), NODE_TIME_RAW);
        parser.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ProfileResult.fromXContent(p), CHILDREN);
        PARSER = parser.build();
    }
}

