/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.elasticsearch.transport;

import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListener;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionListenerResponseHandler;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.ActionType;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.Client;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.support.AbstractClient;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.cluster.node.DiscoveryNode;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.common.settings.Settings;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.threadpool.ThreadPool;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.RemoteClusterAwareRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.RemoteClusterService;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.Transport;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportRequestOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.transport.TransportService;

final class RemoteClusterAwareClient
extends AbstractClient {
    private final TransportService service;
    private final String clusterAlias;
    private final RemoteClusterService remoteClusterService;

    RemoteClusterAwareClient(Settings settings, ThreadPool threadPool, TransportService service, String clusterAlias) {
        super(settings, threadPool);
        this.service = service;
        this.clusterAlias = clusterAlias;
        this.remoteClusterService = service.getRemoteClusterService();
    }

    @Override
    protected <Request extends ActionRequest, Response extends ActionResponse> void doExecute(ActionType<Response> action, Request request, ActionListener<Response> listener) {
        this.remoteClusterService.ensureConnected(this.clusterAlias, ActionListener.wrap(v -> {
            Transport.Connection connection;
            if (request instanceof RemoteClusterAwareRequest) {
                DiscoveryNode preferredTargetNode = ((RemoteClusterAwareRequest)((Object)request)).getPreferredTargetNode();
                connection = this.remoteClusterService.getConnection(preferredTargetNode, this.clusterAlias);
            } else {
                connection = this.remoteClusterService.getConnection(this.clusterAlias);
            }
            this.service.sendRequest(connection, action.name(), (TransportRequest)request, TransportRequestOptions.EMPTY, new ActionListenerResponseHandler(listener, action.getResponseReader()));
        }, listener::onFailure));
    }

    @Override
    public void close() {
    }

    @Override
    public Client getRemoteClusterClient(String clusterAlias) {
        return this.remoteClusterService.getRemoteClusterClient(this.threadPool(), clusterAlias);
    }
}

