/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.support.IndicesOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.RequestOptions;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.core.CountRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.client.core.CountResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.BoolQueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.filter.Filter;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.histogram.ParsedDateHistogram;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.storage.elasticsearch7.ElasticsearchClient;
import org.graylog2.indexer.IndexToolsAdapter;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class IndexToolsAdapterES7
implements IndexToolsAdapter {
    private static final String AGG_DATE_HISTOGRAM = "source_date_histogram";
    private static final String AGG_MESSAGE_FIELD = "message_field";
    private static final String AGG_FILTER = "message_filter";
    private final ElasticsearchClient client;

    @Inject
    public IndexToolsAdapterES7(ElasticsearchClient client) {
        this.client = client;
    }

    public Map<DateTime, Map<String, Long>> fieldHistogram(String fieldName, Set<String> indices, Optional<Set<String>> includedStreams, long interval) {
        BoolQueryBuilder queryBuilder = this.buildStreamIdFilter(includedStreams);
        FilterAggregationBuilder the_filter = (FilterAggregationBuilder)AggregationBuilders.filter(AGG_FILTER, queryBuilder).subAggregation(((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram(AGG_DATE_HISTOGRAM).field("timestamp")).subAggregation((AggregationBuilder)AggregationBuilders.terms(AGG_MESSAGE_FIELD).field(fieldName))).fixedInterval(new DateHistogramInterval(interval + "ms")).minDocCount(1L));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(QueryBuilders.matchAllQuery()).aggregation(the_filter);
        SearchRequest searchRequest = new SearchRequest().source(searchSourceBuilder).indices(indices.toArray(new String[0]));
        SearchResponse searchResult = this.client.search(searchRequest, "Unable to retrieve field histogram.");
        Filter filterAggregation = (Filter)searchResult.getAggregations().get(AGG_FILTER);
        ParsedDateHistogram dateHistogram = (ParsedDateHistogram)filterAggregation.getAggregations().get(AGG_DATE_HISTOGRAM);
        List<? extends Histogram.Bucket> histogramBuckets = dateHistogram.getBuckets();
        HashMap result = Maps.newHashMapWithExpectedSize((int)histogramBuckets.size());
        for (ParsedDateHistogram.ParsedBucket parsedBucket : histogramBuckets) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)parsedBucket.getKey();
            DateTime date = new DateTime(zonedDateTime.toInstant().toEpochMilli()).toDateTime(DateTimeZone.UTC);
            Terms sourceFieldAgg = (Terms)parsedBucket.getAggregations().get(AGG_MESSAGE_FIELD);
            List<? extends Terms.Bucket> termBuckets = sourceFieldAgg.getBuckets();
            HashMap termCounts = Maps.newHashMapWithExpectedSize((int)termBuckets.size());
            for (Terms.Bucket bucket : termBuckets) {
                termCounts.put(bucket.getKeyAsString(), bucket.getDocCount());
            }
            result.put(date, termCounts);
        }
        return ImmutableMap.copyOf((Map)result);
    }

    public long count(Set<String> indices, Optional<Set<String>> includedStreams) {
        CountRequest request = new CountRequest(indices.toArray(new String[0]), this.buildStreamIdFilter(includedStreams)).indicesOptions(IndicesOptions.fromOptions(true, false, true, false));
        CountResponse result = this.client.execute((c, requestOptions) -> c.count(request, (RequestOptions)requestOptions), "Unable to count documents of index.");
        return result.getCount();
    }

    private BoolQueryBuilder buildStreamIdFilter(Optional<Set<String>> includedStreams) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must(QueryBuilders.matchAllQuery());
        if (includedStreams.isPresent()) {
            Set<String> streams = includedStreams.get();
            BoolQueryBuilder filterBuilder = QueryBuilders.boolQuery();
            if (streams.contains("000000000000000000000001")) {
                filterBuilder.should(QueryBuilders.boolQuery().mustNot(QueryBuilders.existsQuery("streams")));
            }
            filterBuilder.should(QueryBuilders.termsQuery("streams", streams));
            queryBuilder.filter(filterBuilder);
        }
        return queryBuilder;
    }
}

