/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7;

import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.BoolQueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.index.query.QueryBuilders;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.graylog.storage.elasticsearch7.SearchCommand;
import org.graylog.storage.elasticsearch7.SortOrderMapper;
import org.graylog.storage.elasticsearch7.TimeRangeQueryFactory;
import org.graylog2.indexer.searches.ScrollCommand;
import org.graylog2.indexer.searches.SearchesConfig;
import org.graylog2.indexer.searches.Sorting;

public class SearchRequestFactory {
    private static final Sorting DEFAULT_SORTING = new Sorting("_doc", Sorting.Direction.ASC);
    private final SortOrderMapper sortOrderMapper;
    private final boolean allowHighlighting;
    private final boolean allowLeadingWildcardSearches;

    @Inject
    public SearchRequestFactory(SortOrderMapper sortOrderMapper, @Named(value="allow_highlighting") boolean allowHighlighting, @Named(value="allow_leading_wildcard_searches") boolean allowLeadingWildcardSearches) {
        this.sortOrderMapper = sortOrderMapper;
        this.allowHighlighting = allowHighlighting;
        this.allowLeadingWildcardSearches = allowLeadingWildcardSearches;
    }

    public SearchSourceBuilder create(SearchesConfig config) {
        return this.create(SearchCommand.from(config));
    }

    public SearchSourceBuilder create(ScrollCommand scrollCommand) {
        return this.create(SearchCommand.from(scrollCommand));
    }

    public SearchSourceBuilder create(SearchCommand searchCommand) {
        String query = this.normalizeQuery(searchCommand.query());
        MatchAllQueryBuilder queryBuilder = this.isWildcardQuery(query) ? QueryBuilders.matchAllQuery() : QueryBuilders.queryStringQuery(query).allowLeadingWildcard(this.allowLeadingWildcardSearches);
        Optional<BoolQueryBuilder> rangeQueryBuilder = searchCommand.range().map(TimeRangeQueryFactory::create).map(rangeQuery -> QueryBuilders.boolQuery().must((QueryBuilder)rangeQuery));
        Optional<BoolQueryBuilder> filterQueryBuilder = searchCommand.filter().filter(filter -> !this.isWildcardQuery((String)filter)).map(QueryBuilders::queryStringQuery).map(queryStringQuery -> QueryBuilders.boolQuery().must((QueryBuilder)queryStringQuery));
        BoolQueryBuilder filteredQueryBuilder = QueryBuilders.boolQuery().must(queryBuilder);
        filterQueryBuilder.ifPresent(filteredQueryBuilder::filter);
        rangeQueryBuilder.ifPresent(filteredQueryBuilder::filter);
        this.applyStreamsFilter(filteredQueryBuilder, searchCommand);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(filteredQueryBuilder).trackTotalHits(true);
        this.applyPaginationIfPresent(searchSourceBuilder, searchCommand);
        this.applySortingIfPresent(searchSourceBuilder, searchCommand);
        this.applyHighlighting(searchSourceBuilder);
        return searchSourceBuilder;
    }

    private void applyHighlighting(SearchSourceBuilder searchSourceBuilder) {
        if (this.allowHighlighting) {
            HighlightBuilder highlightBuilder = (HighlightBuilder)((HighlightBuilder)((HighlightBuilder)new HighlightBuilder().requireFieldMatch(false)).field("*").fragmentSize(0)).numOfFragments(0);
            searchSourceBuilder.highlighter(highlightBuilder);
        }
    }

    private void applyPaginationIfPresent(SearchSourceBuilder searchSourceBuilder, SearchCommand command) {
        command.offset().ifPresent(searchSourceBuilder::from);
        command.limit().ifPresent(searchSourceBuilder::size);
    }

    private void applyStreamsFilter(BoolQueryBuilder filteredQueryBuilder, SearchCommand command) {
        command.streams().map(this::buildStreamIdFilter).ifPresent(filteredQueryBuilder::filter);
    }

    private BoolQueryBuilder buildStreamIdFilter(Set<String> streams) {
        BoolQueryBuilder filterBuilder = QueryBuilders.boolQuery();
        if (streams.contains("000000000000000000000001")) {
            filterBuilder.should(QueryBuilders.boolQuery().mustNot(QueryBuilders.existsQuery("streams")));
        }
        filterBuilder.should(QueryBuilders.termsQuery("streams", streams));
        return filterBuilder;
    }

    private void applySortingIfPresent(SearchSourceBuilder searchSourceBuilder, SearchCommand command) {
        Sorting sort = command.sorting().orElse(DEFAULT_SORTING);
        searchSourceBuilder.sort(sort.getField(), this.sortOrderMapper.fromSorting(sort));
    }

    private boolean isWildcardQuery(String filter) {
        return this.normalizeQuery(filter).equals("*");
    }

    private String normalizeQuery(String query) {
        if (query == null || query.trim().isEmpty()) {
            return "*";
        }
        return query.trim();
    }
}

