/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.elasticsearch7.views.export;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.plugins.views.search.export.ExportMessagesCommand;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchRequest;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.action.search.SearchResponse;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.SearchHit;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.builder.SearchSourceBuilder;
import org.graylog.shaded.elasticsearch7.org.elasticsearch.search.sort.SortOrder;
import org.graylog.storage.elasticsearch7.views.export.ExportClient;
import org.graylog.storage.elasticsearch7.views.export.RequestStrategy;

public class SearchAfter
implements RequestStrategy {
    static final String DEFAULT_TIEBREAKER_FIELD = "gl2_message_id";
    static final String EVENTS_TIEBREAKER_FIELD = "_id";
    private final ExportClient client;
    private Object[] searchAfterValues = null;

    @Inject
    public SearchAfter(ExportClient client) {
        this.client = client;
    }

    @Override
    public List<SearchHit> nextChunk(SearchRequest search, ExportMessagesCommand command) {
        SearchResponse result = this.search(search);
        List<SearchHit> hits = Streams.stream((Iterable)result.getHits()).collect(Collectors.toList());
        this.searchAfterValues = this.lastHitSortFrom(hits);
        return hits;
    }

    private SearchResponse search(SearchRequest search) {
        this.configureSort(search.source());
        return this.client.search(search, "Failed to execute Search After request");
    }

    private void configureSort(SearchSourceBuilder source) {
        source.sort("timestamp", SortOrder.DESC);
        source.sort(DEFAULT_TIEBREAKER_FIELD, SortOrder.DESC);
    }

    private Object[] lastHitSortFrom(List<SearchHit> hits) {
        if (hits.isEmpty()) {
            return null;
        }
        SearchHit lastHit = hits.get(hits.size() - 1);
        return lastHit.getSortValues();
    }

    @Override
    public SearchSourceBuilder configure(SearchSourceBuilder ssb) {
        return this.searchAfterValues == null ? ssb : ssb.searchAfter(this.searchAfterValues);
    }
}

