/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.searchbox.action.AbstractAction;
import io.searchbox.action.BulkableAction;
import io.searchbox.core.BulkResult;
import io.searchbox.params.Parameters;
import io.searchbox.strings.StringUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bulk
extends AbstractAction<BulkResult> {
    static final Logger log = LoggerFactory.getLogger(Bulk.class);
    protected Collection<BulkableAction> bulkableActions;

    protected Bulk(Builder builder) {
        super(builder);
        this.indexName = builder.defaultIndex;
        this.typeName = builder.defaultType;
        this.bulkableActions = builder.actions;
        this.setURI(this.buildURI());
    }

    private Object getJson(ObjectMapper objectMapper, Object source) throws JsonProcessingException {
        if (source instanceof String) {
            return source;
        }
        return objectMapper.writeValueAsString(source);
    }

    @Override
    public String getRestMethodName() {
        return "POST";
    }

    @Override
    public String getData(ObjectMapper objectMapper) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (BulkableAction action : this.bulkableActions) {
            LinkedHashMap opMap = new LinkedHashMap(1);
            LinkedHashMap<String, String> opDetails = new LinkedHashMap<String, String>(3);
            if (!StringUtils.isBlank(action.getId())) {
                opDetails.put("_id", action.getId());
            }
            if (!StringUtils.isBlank(action.getIndex())) {
                opDetails.put("_index", action.getIndex());
            }
            if (!StringUtils.isBlank(action.getType())) {
                opDetails.put("_type", action.getType());
            }
            for (String parameter : Parameters.ACCEPTED_IN_BULK) {
                try {
                    Collection<Object> values = action.getParameter(parameter);
                    if (values == null) continue;
                    if (values.size() == 1) {
                        opDetails.put("_" + parameter, values.iterator().next().toString());
                        continue;
                    }
                    if (values.size() <= 1) continue;
                    throw new IllegalArgumentException("Expecting a single value for '" + parameter + "' parameter, you provided: " + values.size());
                }
                catch (NullPointerException e) {
                    log.debug("Could not retrieve '" + parameter + "' parameter from action.", (Throwable)e);
                }
            }
            opMap.put(action.getBulkMethodName(), opDetails);
            sb.append(objectMapper.writeValueAsString(opMap));
            sb.append("\n");
            String source = action.getData(objectMapper);
            if (source == null) continue;
            sb.append(this.getJson(objectMapper, source));
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public String getPathToResult() {
        return "ok";
    }

    @Override
    protected String buildURI() {
        return super.buildURI() + "/_bulk";
    }

    @Override
    public BulkResult createNewElasticSearchResult(String responseBody, int statusCode, String reasonPhrase, ObjectMapper objectMapper) throws IOException {
        return this.createNewElasticSearchResult(new BulkResult(objectMapper), responseBody, statusCode, reasonPhrase, objectMapper);
    }

    @Override
    protected BulkResult createNewElasticSearchResult(BulkResult result, String responseBody, int statusCode, String reasonPhrase, ObjectMapper objectMapper) throws IOException {
        ObjectNode jsonMap = this.parseResponseBody(responseBody, objectMapper);
        result.setResponseCode(statusCode);
        result.setJsonString(responseBody);
        result.setJsonObject((JsonNode)jsonMap);
        result.setPathToResult(this.getPathToResult());
        if (this.isHttpSuccessful(statusCode)) {
            if (jsonMap.has("errors") && jsonMap.get("errors").asBoolean()) {
                result.setSucceeded(false);
                result.setErrorMessage("One or more of the items in the Bulk request failed, check BulkResult.getItems() for more information.");
                log.debug("Bulk operation failed due to one or more failed actions within the Bulk request");
            } else {
                result.setSucceeded(true);
                log.debug("Bulk operation was successfull");
            }
        } else {
            result.setSucceeded(false);
            if (result.getErrorMessage() == null) {
                result.setErrorMessage(statusCode + " " + (reasonPhrase == null ? "null" : reasonPhrase));
            }
            log.debug("Bulk operation failed with an HTTP error");
        }
        return result;
    }

    public static class Builder
    extends AbstractAction.Builder<Bulk, Builder> {
        private List<BulkableAction> actions = new LinkedList<BulkableAction>();
        private String defaultIndex;
        private String defaultType;

        public Builder defaultIndex(String defaultIndex) {
            this.defaultIndex = defaultIndex;
            return this;
        }

        public Builder defaultType(String defaultType) {
            this.defaultType = defaultType;
            return this;
        }

        public Builder addAction(BulkableAction action) {
            this.actions.add(action);
            return this;
        }

        public Builder addAction(Collection<? extends BulkableAction> actions) {
            this.actions.addAll(actions);
            return this;
        }

        @Override
        public Bulk build() {
            return new Bulk(this);
        }
    }
}

