/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.aggregation;

import com.fasterxml.jackson.databind.JsonNode;
import io.searchbox.core.search.aggregation.Aggregation;
import io.searchbox.core.search.aggregation.AvgAggregation;
import io.searchbox.core.search.aggregation.CardinalityAggregation;
import io.searchbox.core.search.aggregation.DateHistogramAggregation;
import io.searchbox.core.search.aggregation.DateRangeAggregation;
import io.searchbox.core.search.aggregation.ExtendedStatsAggregation;
import io.searchbox.core.search.aggregation.FilterAggregation;
import io.searchbox.core.search.aggregation.FiltersAggregation;
import io.searchbox.core.search.aggregation.GeoBoundsAggregation;
import io.searchbox.core.search.aggregation.GeoDistanceAggregation;
import io.searchbox.core.search.aggregation.GeoHashGridAggregation;
import io.searchbox.core.search.aggregation.HistogramAggregation;
import io.searchbox.core.search.aggregation.Ipv4RangeAggregation;
import io.searchbox.core.search.aggregation.MaxAggregation;
import io.searchbox.core.search.aggregation.MinAggregation;
import io.searchbox.core.search.aggregation.MissingAggregation;
import io.searchbox.core.search.aggregation.PercentileRanksAggregation;
import io.searchbox.core.search.aggregation.PercentilesAggregation;
import io.searchbox.core.search.aggregation.RangeAggregation;
import io.searchbox.core.search.aggregation.ScriptedMetricAggregation;
import io.searchbox.core.search.aggregation.SignificantTermsAggregation;
import io.searchbox.core.search.aggregation.StatsAggregation;
import io.searchbox.core.search.aggregation.SumAggregation;
import io.searchbox.core.search.aggregation.TermsAggregation;
import io.searchbox.core.search.aggregation.TopHitsAggregation;
import io.searchbox.core.search.aggregation.ValueCountAggregation;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class MetricAggregation
extends Aggregation {
    public MetricAggregation(String name, JsonNode root) {
        super(name, root);
    }

    public List<Aggregation> getAggregations(Map<String, Class> nameToTypeMap) {
        ArrayList<Aggregation> aggregations = new ArrayList<Aggregation>();
        for (String nameCandidate : nameToTypeMap.keySet()) {
            if (!this.jsonRoot.has(nameCandidate)) continue;
            try {
                Class type = nameToTypeMap.get(nameCandidate);
                Constructor c = type.getConstructor(String.class, JsonNode.class);
                aggregations.add((Aggregation)c.newInstance(nameCandidate, this.jsonRoot.get(nameCandidate)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return aggregations;
    }

    public <T extends Aggregation> T getAggregation(String aggName, Class<T> aggType) {
        if (this.jsonRoot.has(aggName)) {
            try {
                Constructor<T> c = aggType.getConstructor(String.class, JsonNode.class);
                return (T)((Aggregation)c.newInstance(aggName, this.jsonRoot.get(aggName)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public AvgAggregation getAvgAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new AvgAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public CardinalityAggregation getCardinalityAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new CardinalityAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public DateHistogramAggregation getDateHistogramAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new DateHistogramAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public DateRangeAggregation getDateRangeAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new DateRangeAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public ExtendedStatsAggregation getExtendedStatsAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new ExtendedStatsAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public FilterAggregation getFilterAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new FilterAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public FiltersAggregation getFiltersAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new FiltersAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public GeoBoundsAggregation getGeoBoundsAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new GeoBoundsAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public GeoDistanceAggregation getGeoDistanceAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new GeoDistanceAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public GeoHashGridAggregation getGeohashGridAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new GeoHashGridAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public HistogramAggregation getHistogramAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new HistogramAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public Ipv4RangeAggregation getIpv4RangeAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new Ipv4RangeAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public MaxAggregation getMaxAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new MaxAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public MinAggregation getMinAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new MinAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public MissingAggregation getMissingAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new MissingAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public PercentileRanksAggregation getPercentileRanksAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new PercentileRanksAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public PercentilesAggregation getPercentilesAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new PercentilesAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public RangeAggregation getRangeAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new RangeAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public ScriptedMetricAggregation getScriptedMetricAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new ScriptedMetricAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public SignificantTermsAggregation getSignificantTermsAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new SignificantTermsAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public StatsAggregation getStatsAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new StatsAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public SumAggregation getSumAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new SumAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public TermsAggregation getTermsAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new TermsAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public ValueCountAggregation getValueCountAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new ValueCountAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }

    public TopHitsAggregation getTopHitsAggregation(String aggName) {
        return this.jsonRoot.has(aggName) ? new TopHitsAggregation(aggName, this.jsonRoot.get(aggName)) : null;
    }
}

