/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.aggregation;

import com.fasterxml.jackson.databind.JsonNode;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.BucketAggregation;
import io.searchbox.core.search.aggregation.Range;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class RangeAggregation
extends BucketAggregation {
    public static final String TYPE = "range";
    private List<Range> ranges = new ArrayList<Range>();

    public RangeAggregation(String name, JsonNode rangeAggregation) {
        super(name, rangeAggregation);
        Iterator iterator = rangeAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).iterator();
        while (iterator.hasNext()) {
            JsonNode bucket;
            Range range = new Range(bucket, (bucket = (JsonNode)iterator.next()).has(String.valueOf((Object)AggregationField.FROM)) ? Double.valueOf(bucket.get(String.valueOf((Object)AggregationField.FROM)).asDouble()) : null, bucket.has(String.valueOf((Object)AggregationField.TO)) ? Double.valueOf(bucket.get(String.valueOf((Object)AggregationField.TO)).asDouble()) : null, bucket.get(String.valueOf((Object)AggregationField.DOC_COUNT)).asLong());
            this.ranges.add(range);
        }
    }

    public List<Range> getBuckets() {
        return this.ranges;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        RangeAggregation rhs = (RangeAggregation)obj;
        return super.equals(obj) && Objects.equals(this.ranges, rhs.ranges);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.ranges);
    }
}

