/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc;

import java.util.Arrays;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.IntCollection;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.IntLookupContainer;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.cursors.IntCursor;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.predicates.IntPredicate;

abstract class AbstractIntCollection
implements IntCollection {
    AbstractIntCollection() {
    }

    @Override
    public int removeAll(final IntLookupContainer c) {
        return this.removeAll(new IntPredicate(){

            @Override
            public boolean apply(int k) {
                return c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final IntLookupContainer c) {
        return this.removeAll(new IntPredicate(){

            @Override
            public boolean apply(int k) {
                return !c.contains(k);
            }
        });
    }

    @Override
    public int retainAll(final IntPredicate predicate) {
        return this.removeAll(new IntPredicate(){

            @Override
            public boolean apply(int value) {
                return !predicate.apply(value);
            }
        });
    }

    @Override
    public int[] toArray() {
        int[] array = new int[this.size()];
        int i = 0;
        for (IntCursor c : this) {
            array[i++] = c.value;
        }
        return array;
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

