/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc;

import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.ArraySizingStrategy;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.BufferAllocationException;

public final class BoundedProportionalArraySizingStrategy
implements ArraySizingStrategy {
    public static final int MAX_ARRAY_LENGTH = 0x7FFFFFDF;
    public static final int DEFAULT_MIN_GROW_COUNT = 10;
    public static final int DEFAULT_MAX_GROW_COUNT = 0x7FFFFFDF;
    public static final float DEFAULT_GROW_RATIO = 1.5f;
    public final int minGrowCount;
    public final int maxGrowCount;
    public final float growRatio;

    public BoundedProportionalArraySizingStrategy() {
        this(10, 0x7FFFFFDF, 1.5f);
    }

    public BoundedProportionalArraySizingStrategy(int minGrow, int maxGrow, float ratio) {
        assert (minGrow >= 1) : "Min grow must be >= 1.";
        assert (maxGrow >= minGrow) : "Max grow must be >= min grow.";
        assert (ratio >= 1.0f) : "Growth ratio must be >= 1 (was " + ratio + ").";
        this.minGrowCount = minGrow;
        this.maxGrowCount = maxGrow;
        this.growRatio = ratio - 1.0f;
    }

    @Override
    public int grow(int currentBufferLength, int elementsCount, int expectedAdditions) {
        long growBy = (long)((float)currentBufferLength * this.growRatio);
        growBy = Math.max(growBy, (long)this.minGrowCount);
        long growTo = Math.min(0x7FFFFFDFL, (growBy = Math.min(growBy, (long)this.maxGrowCount)) + (long)currentBufferLength);
        long newSize = Math.max((long)elementsCount + (long)expectedAdditions, growTo);
        if (newSize > 0x7FFFFFDFL) {
            throw new BufferAllocationException("Java array size exceeded (current length: %d, elements: %d, expected additions: %d)", currentBufferLength, elementsCount, expectedAdditions);
        }
        return (int)newSize;
    }
}

