/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc;

import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.ArraySizingStrategy;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.ByteArrayList;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.ByteContainer;
import org.graylog.shaded.elasticsearch5.com.carrotsearch.hppc.cursors.ByteCursor;

public class ByteStack
extends ByteArrayList {
    public ByteStack() {
    }

    public ByteStack(int expectedElements) {
        super(expectedElements);
    }

    public ByteStack(int expectedElements, ArraySizingStrategy resizer) {
        super(expectedElements, resizer);
    }

    public ByteStack(ByteContainer container) {
        super(container);
    }

    public void push(byte e1) {
        this.ensureBufferSpace(1);
        this.buffer[this.elementsCount++] = e1;
    }

    public void push(byte e1, byte e2) {
        this.ensureBufferSpace(2);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
    }

    public void push(byte e1, byte e2, byte e3) {
        this.ensureBufferSpace(3);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
    }

    public void push(byte e1, byte e2, byte e3, byte e4) {
        this.ensureBufferSpace(4);
        this.buffer[this.elementsCount++] = e1;
        this.buffer[this.elementsCount++] = e2;
        this.buffer[this.elementsCount++] = e3;
        this.buffer[this.elementsCount++] = e4;
    }

    public void push(byte[] elements, int start, int len) {
        assert (start >= 0 && len >= 0);
        this.ensureBufferSpace(len);
        System.arraycopy(elements, start, this.buffer, this.elementsCount, len);
        this.elementsCount += len;
    }

    public final void push(byte ... elements) {
        this.push(elements, 0, elements.length);
    }

    public int pushAll(ByteContainer container) {
        return this.addAll(container);
    }

    public int pushAll(Iterable<? extends ByteCursor> iterable) {
        return this.addAll(iterable);
    }

    public void discard(int count) {
        assert (this.elementsCount >= count);
        this.elementsCount -= count;
    }

    public void discard() {
        assert (this.elementsCount > 0);
        --this.elementsCount;
    }

    public byte pop() {
        assert (this.elementsCount > 0);
        byte v = this.buffer[--this.elementsCount];
        return v;
    }

    public byte peek() {
        assert (this.elementsCount > 0);
        return this.buffer[this.elementsCount - 1];
    }

    public static ByteStack from(byte ... elements) {
        ByteStack stack = new ByteStack(elements.length);
        stack.push(elements);
        return stack;
    }

    @Override
    public ByteStack clone() {
        return (ByteStack)super.clone();
    }
}

