/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.com.tdunning.math.stats;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class Centroid
implements Comparable<Centroid> {
    private static final AtomicInteger uniqueCount = new AtomicInteger(1);
    private double centroid = 0.0;
    private int count = 0;
    private int id = uniqueCount.incrementAndGet();
    private List<Double> actualData = null;

    Centroid(boolean record) {
        if (record) {
            this.actualData = new ArrayList<Double>();
        }
    }

    public Centroid(double x) {
        this(false);
        this.start(x, 1, uniqueCount.getAndIncrement());
    }

    public Centroid(double x, int w) {
        this(false);
        this.start(x, w, uniqueCount.getAndIncrement());
    }

    public Centroid(double x, int w, int id) {
        this(false);
        this.start(x, w, id);
    }

    public Centroid(double x, int id, boolean record) {
        this(record);
        this.start(x, 1, id);
    }

    private void start(double x, int w, int id) {
        this.id = id;
        this.add(x, w);
    }

    public void add(double x, int w) {
        if (this.actualData != null) {
            this.actualData.add(x);
        }
        this.count += w;
        this.centroid += (double)w * (x - this.centroid) / (double)this.count;
    }

    public double mean() {
        return this.centroid;
    }

    public int count() {
        return this.count;
    }

    public int id() {
        return this.id;
    }

    public String toString() {
        return "Centroid{centroid=" + this.centroid + ", count=" + this.count + '}';
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public int compareTo(Centroid o) {
        int r = Double.compare(this.centroid, o.centroid);
        if (r == 0) {
            r = this.id - o.id;
        }
        return r;
    }

    public List<Double> data() {
        return this.actualData;
    }

    public void insertData(double x) {
        if (this.actualData == null) {
            this.actualData = new ArrayList<Double>();
        }
        this.actualData.add(x);
    }

    public static Centroid createWeighted(double x, int w, Iterable<? extends Double> data) {
        Centroid r = new Centroid(data != null);
        r.add(x, w, data);
        return r;
    }

    public void add(double x, int w, Iterable<? extends Double> data) {
        if (this.actualData != null) {
            if (data != null) {
                for (Double d : data) {
                    this.actualData.add(d);
                }
            } else {
                this.actualData.add(x);
            }
        }
        this.count += w;
        this.centroid += (double)w * (x - this.centroid) / (double)this.count;
    }
}

