/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.PointsReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.FieldInfo;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MergeState;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.PointValues;

public abstract class PointsWriter
implements Closeable {
    protected PointsWriter() {
    }

    public abstract void writeField(FieldInfo var1, PointsReader var2) throws IOException;

    protected void mergeOneField(final MergeState mergeState, final FieldInfo fieldInfo) throws IOException {
        long maxPointCount = 0L;
        int docCount = 0;
        for (int i = 0; i < mergeState.pointsReaders.length; ++i) {
            FieldInfo readerFieldInfo;
            PointsReader pointsReader = mergeState.pointsReaders[i];
            if (pointsReader == null || (readerFieldInfo = mergeState.fieldInfos[i].fieldInfo(fieldInfo.name)) == null || readerFieldInfo.getPointDimensionCount() <= 0) continue;
            maxPointCount += pointsReader.size(fieldInfo.name);
            docCount += pointsReader.getDocCount(fieldInfo.name);
        }
        final long finalMaxPointCount = maxPointCount;
        final int finalDocCount = docCount;
        this.writeField(fieldInfo, new PointsReader(){

            @Override
            public void intersect(String fieldName, final PointValues.IntersectVisitor mergedVisitor) throws IOException {
                if (!fieldName.equals(fieldInfo.name)) {
                    throw new IllegalArgumentException("field name must match the field being merged");
                }
                for (int i = 0; i < mergeState.pointsReaders.length; ++i) {
                    FieldInfo readerFieldInfo;
                    PointsReader pointsReader = mergeState.pointsReaders[i];
                    if (pointsReader == null || (readerFieldInfo = mergeState.fieldInfos[i].fieldInfo(fieldName)) == null || readerFieldInfo.getPointDimensionCount() == 0) continue;
                    final MergeState.DocMap docMap = mergeState.docMaps[i];
                    pointsReader.intersect(fieldInfo.name, new PointValues.IntersectVisitor(){

                        @Override
                        public void visit(int docID) {
                            throw new IllegalStateException();
                        }

                        @Override
                        public void visit(int docID, byte[] packedValue) throws IOException {
                            int newDocID = docMap.get(docID);
                            if (newDocID != -1) {
                                mergedVisitor.visit(newDocID, packedValue);
                            }
                        }

                        @Override
                        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                            return PointValues.Relation.CELL_CROSSES_QUERY;
                        }
                    });
                }
            }

            @Override
            public void checkIntegrity() {
                throw new UnsupportedOperationException();
            }

            @Override
            public long ramBytesUsed() {
                return 0L;
            }

            @Override
            public void close() {
            }

            @Override
            public long estimatePointCount(String fieldName, PointValues.IntersectVisitor visitor) {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte[] getMinPackedValue(String fieldName) {
                throw new UnsupportedOperationException();
            }

            @Override
            public byte[] getMaxPackedValue(String fieldName) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getNumDimensions(String fieldName) {
                throw new UnsupportedOperationException();
            }

            @Override
            public int getBytesPerDimension(String fieldName) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long size(String fieldName) {
                return finalMaxPointCount;
            }

            @Override
            public int getDocCount(String fieldName) {
                return finalDocCount;
            }
        });
    }

    public void merge(MergeState mergeState) throws IOException {
        for (PointsReader reader : mergeState.pointsReaders) {
            if (reader == null) continue;
            reader.checkIntegrity();
        }
        for (FieldInfo fieldInfo : mergeState.mergeFieldInfos) {
            if (fieldInfo.getPointDimensionCount() == 0) continue;
            this.mergeOneField(mergeState, fieldInfo);
        }
        this.finish();
    }

    public abstract void finish() throws IOException;
}

