/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.CodecUtil;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.codecs.SegmentInfoFormat;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.CorruptIndexException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexFileNames;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SegmentInfo;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.ChecksumIndexInput;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.Directory;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.store.IOContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Version;

@Deprecated
public class Lucene50SegmentInfoFormat
extends SegmentInfoFormat {
    public static final String SI_EXTENSION = "si";
    static final String CODEC_NAME = "Lucene50SegmentInfo";
    static final int VERSION_START = 0;
    static final int VERSION_SAFE_MAPS = 1;
    static final int VERSION_CURRENT = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentInfo read(Directory dir, String segment, byte[] segmentID, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName(segment, "", SI_EXTENSION);
        try (ChecksumIndexInput input = dir.openChecksumInput(fileName, context);){
            Throwable priorE = null;
            SegmentInfo si = null;
            try {
                Map<String, String> attributes;
                Set<String> files;
                Map<String, String> diagnostics;
                boolean isCompoundFile;
                int format = CodecUtil.checkIndexHeader(input, CODEC_NAME, 0, 1, segmentID, "");
                Version version = Version.fromBits(input.readInt(), input.readInt(), input.readInt());
                int docCount = input.readInt();
                if (docCount < 0) {
                    throw new CorruptIndexException("invalid docCount: " + docCount, input);
                }
                boolean bl = isCompoundFile = input.readByte() == 1;
                if (format >= 1) {
                    diagnostics = input.readMapOfStrings();
                    files = input.readSetOfStrings();
                    attributes = input.readMapOfStrings();
                } else {
                    diagnostics = Collections.unmodifiableMap(input.readStringStringMap());
                    files = Collections.unmodifiableSet(input.readStringSet());
                    attributes = Collections.unmodifiableMap(input.readStringStringMap());
                }
                si = new SegmentInfo(dir, version, segment, docCount, isCompoundFile, null, diagnostics, segmentID, attributes, null);
                si.setFiles(files);
            }
            catch (Throwable exception) {
                priorE = exception;
            }
            finally {
                CodecUtil.checkFooter(input, priorE);
            }
            SegmentInfo segmentInfo = si;
            return segmentInfo;
        }
    }

    @Override
    public void write(Directory dir, SegmentInfo si, IOContext ioContext) throws IOException {
        throw new UnsupportedOperationException("this codec can only be used for reading");
    }
}

