/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.document;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.geo.GeoEncodingUtils;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.geo.GeoUtils;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedNumericDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.ConstantScoreScorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.ConstantScoreWeight;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.IndexSearcher;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Query;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.TwoPhaseIterator;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Weight;

final class LatLonDocValuesDistanceQuery
extends Query {
    private final String field;
    private final double latitude;
    private final double longitude;
    private final double radiusMeters;

    LatLonDocValuesDistanceQuery(String field, double latitude, double longitude, double radiusMeters) {
        if (!Double.isFinite(radiusMeters) || radiusMeters < 0.0) {
            throw new IllegalArgumentException("radiusMeters: '" + radiusMeters + "' is invalid");
        }
        GeoUtils.checkLatitude(latitude);
        GeoUtils.checkLongitude(longitude);
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        this.field = field;
        this.latitude = latitude;
        this.longitude = longitude;
        this.radiusMeters = radiusMeters;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        if (!this.field.equals(field)) {
            sb.append(this.field);
            sb.append(':');
        }
        sb.append(this.latitude);
        sb.append(",");
        sb.append(this.longitude);
        sb.append(" +/- ");
        sb.append(this.radiusMeters);
        sb.append(" meters");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!this.sameClassAs(obj)) {
            return false;
        }
        LatLonDocValuesDistanceQuery other = (LatLonDocValuesDistanceQuery)obj;
        return this.field.equals(other.field) && Double.doubleToLongBits(this.latitude) == Double.doubleToLongBits(other.latitude) && Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(other.longitude) && Double.doubleToLongBits(this.radiusMeters) == Double.doubleToLongBits(other.radiusMeters);
    }

    @Override
    public int hashCode() {
        int h = this.classHash();
        h = 31 * h + this.field.hashCode();
        h = 31 * h + Double.hashCode(this.latitude);
        h = 31 * h + Double.hashCode(this.longitude);
        h = 31 * h + Double.hashCode(this.radiusMeters);
        return h;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){
            private final GeoEncodingUtils.DistancePredicate distancePredicate;
            {
                this.distancePredicate = GeoEncodingUtils.createDistancePredicate(LatLonDocValuesDistanceQuery.this.latitude, LatLonDocValuesDistanceQuery.this.longitude, LatLonDocValuesDistanceQuery.this.radiusMeters);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                final SortedNumericDocValues values = context.reader().getSortedNumericDocValues(LatLonDocValuesDistanceQuery.this.field);
                if (values == null) {
                    return null;
                }
                TwoPhaseIterator iterator = new TwoPhaseIterator(DocIdSetIterator.all(context.reader().maxDoc())){

                    @Override
                    public boolean matches() throws IOException {
                        values.setDocument(this.approximation.docID());
                        int count = values.count();
                        for (int i = 0; i < count; ++i) {
                            long value = values.valueAt(i);
                            int lat = (int)(value >>> 32);
                            int lon = (int)(value & 0xFFFFFFFFFFFFFFFFL);
                            if (!distancePredicate.test(lat, lon)) continue;
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public float matchCost() {
                        return 100.0f;
                    }
                };
                return new ConstantScoreScorer((Weight)this, this.score(), iterator);
            }
        };
    }
}

