/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.index;

import java.io.IOException;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.FilterLeafReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MappingMultiPostingsEnum;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MergeState;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MultiFields;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MultiPostingsEnum;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MultiTerms;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.MultiTermsEnum;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.PostingsEnum;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.Terms;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.TermsEnum;

public class MappedMultiFields
extends FilterLeafReader.FilterFields {
    final MergeState mergeState;

    public MappedMultiFields(MergeState mergeState, MultiFields multiFields) {
        super(multiFields);
        this.mergeState = mergeState;
    }

    @Override
    public Terms terms(String field) throws IOException {
        MultiTerms terms = (MultiTerms)this.in.terms(field);
        if (terms == null) {
            return null;
        }
        return new MappedMultiTerms(field, this.mergeState, terms);
    }

    private static class MappedMultiTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        final MergeState mergeState;
        final String field;

        public MappedMultiTermsEnum(String field, MergeState mergeState, MultiTermsEnum multiTermsEnum) {
            super(multiTermsEnum);
            this.field = field;
            this.mergeState = mergeState;
        }

        @Override
        public int docFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long totalTermFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            MappingMultiPostingsEnum mappingDocsAndPositionsEnum;
            if (reuse instanceof MappingMultiPostingsEnum) {
                MappingMultiPostingsEnum postings = (MappingMultiPostingsEnum)reuse;
                mappingDocsAndPositionsEnum = postings.field.equals(this.field) ? postings : new MappingMultiPostingsEnum(this.field, this.mergeState);
            } else {
                mappingDocsAndPositionsEnum = new MappingMultiPostingsEnum(this.field, this.mergeState);
            }
            MultiPostingsEnum docsAndPositionsEnum = (MultiPostingsEnum)this.in.postings(mappingDocsAndPositionsEnum.multiDocsAndPositionsEnum, flags);
            mappingDocsAndPositionsEnum.reset(docsAndPositionsEnum);
            return mappingDocsAndPositionsEnum;
        }
    }

    private static class MappedMultiTerms
    extends FilterLeafReader.FilterTerms {
        final MergeState mergeState;
        final String field;

        public MappedMultiTerms(String field, MergeState mergeState, MultiTerms multiTerms) {
            super(multiTerms);
            this.field = field;
            this.mergeState = mergeState;
        }

        @Override
        public TermsEnum iterator() throws IOException {
            TermsEnum iterator = this.in.iterator();
            if (iterator == TermsEnum.EMPTY) {
                return TermsEnum.EMPTY;
            }
            return new MappedMultiTermsEnum(this.field, this.mergeState, (MultiTermsEnum)iterator);
        }

        @Override
        public long size() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSumTotalTermFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSumDocFreq() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getDocCount() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

