/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.search;

import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.RandomAccessOrds;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedSetDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;

public class SortedSetSelector {
    public static SortedDocValues wrap(SortedSetDocValues sortedSet, Type selector) {
        if (sortedSet.getValueCount() >= Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("fields containing more than 2147483646 unique terms are unsupported");
        }
        SortedDocValues singleton = DocValues.unwrapSingleton(sortedSet);
        if (singleton != null) {
            return singleton;
        }
        if (selector == Type.MIN) {
            return new MinValue(sortedSet);
        }
        if (!(sortedSet instanceof RandomAccessOrds)) {
            throw new UnsupportedOperationException("codec does not support random access ordinals, cannot use selector: " + (Object)((Object)selector) + " docValsImpl: " + sortedSet.toString());
        }
        RandomAccessOrds randomOrds = (RandomAccessOrds)sortedSet;
        switch (selector) {
            case MAX: {
                return new MaxValue(randomOrds);
            }
            case MIDDLE_MIN: {
                return new MiddleMinValue(randomOrds);
            }
            case MIDDLE_MAX: {
                return new MiddleMaxValue(randomOrds);
            }
        }
        throw new AssertionError();
    }

    static class MiddleMaxValue
    extends SortedDocValues {
        final RandomAccessOrds in;

        MiddleMaxValue(RandomAccessOrds in) {
            this.in = in;
        }

        @Override
        public int getOrd(int docID) {
            this.in.setDocument(docID);
            int count = this.in.cardinality();
            if (count == 0) {
                return -1;
            }
            return (int)this.in.ordAt(count >>> 1);
        }

        @Override
        public BytesRef lookupOrd(int ord) {
            return this.in.lookupOrd(ord);
        }

        @Override
        public int getValueCount() {
            return (int)this.in.getValueCount();
        }

        @Override
        public int lookupTerm(BytesRef key) {
            return (int)this.in.lookupTerm(key);
        }
    }

    static class MiddleMinValue
    extends SortedDocValues {
        final RandomAccessOrds in;

        MiddleMinValue(RandomAccessOrds in) {
            this.in = in;
        }

        @Override
        public int getOrd(int docID) {
            this.in.setDocument(docID);
            int count = this.in.cardinality();
            if (count == 0) {
                return -1;
            }
            return (int)this.in.ordAt(count - 1 >>> 1);
        }

        @Override
        public BytesRef lookupOrd(int ord) {
            return this.in.lookupOrd(ord);
        }

        @Override
        public int getValueCount() {
            return (int)this.in.getValueCount();
        }

        @Override
        public int lookupTerm(BytesRef key) {
            return (int)this.in.lookupTerm(key);
        }
    }

    static class MaxValue
    extends SortedDocValues {
        final RandomAccessOrds in;

        MaxValue(RandomAccessOrds in) {
            this.in = in;
        }

        @Override
        public int getOrd(int docID) {
            this.in.setDocument(docID);
            int count = this.in.cardinality();
            if (count == 0) {
                return -1;
            }
            return (int)this.in.ordAt(count - 1);
        }

        @Override
        public BytesRef lookupOrd(int ord) {
            return this.in.lookupOrd(ord);
        }

        @Override
        public int getValueCount() {
            return (int)this.in.getValueCount();
        }

        @Override
        public int lookupTerm(BytesRef key) {
            return (int)this.in.lookupTerm(key);
        }
    }

    static class MinValue
    extends SortedDocValues {
        final SortedSetDocValues in;

        MinValue(SortedSetDocValues in) {
            this.in = in;
        }

        @Override
        public int getOrd(int docID) {
            this.in.setDocument(docID);
            return (int)this.in.nextOrd();
        }

        @Override
        public BytesRef lookupOrd(int ord) {
            return this.in.lookupOrd(ord);
        }

        @Override
        public int getValueCount() {
            return (int)this.in.getValueCount();
        }

        @Override
        public int lookupTerm(BytesRef key) {
            return (int)this.in.lookupTerm(key);
        }
    }

    public static enum Type {
        MIN,
        MAX,
        MIDDLE_MIN,
        MIDDLE_MAX;

    }
}

