/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.search.grouping.term;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.SortedDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.grouping.DistinctValuesCollector;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.grouping.SearchGroup;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.SentinelIntSet;

public class TermDistinctValuesCollector
extends DistinctValuesCollector<BytesRef> {
    private final String groupField;
    private final String countField;
    private final List<TermGroupCount> groups;
    private final SentinelIntSet ordSet;
    private final TermGroupCount[] groupCounts;
    private SortedDocValues groupFieldTermIndex;
    private SortedDocValues countFieldTermIndex;

    public TermDistinctValuesCollector(String groupField, String countField, Collection<SearchGroup<BytesRef>> groups) {
        this.groupField = groupField;
        this.countField = countField;
        this.groups = new ArrayList<TermGroupCount>(groups.size());
        for (SearchGroup<BytesRef> group : groups) {
            this.groups.add(new TermGroupCount((BytesRef)group.groupValue));
        }
        this.ordSet = new SentinelIntSet(groups.size(), -2);
        this.groupCounts = new TermGroupCount[this.ordSet.keys.length];
    }

    @Override
    public void collect(int doc) throws IOException {
        int slot = this.ordSet.find(this.groupFieldTermIndex.getOrd(doc));
        if (slot < 0) {
            return;
        }
        TermGroupCount gc = this.groupCounts[slot];
        int countOrd = this.countFieldTermIndex.getOrd(doc);
        if (this.doesNotContainOrd(countOrd, gc.ords)) {
            if (countOrd == -1) {
                gc.uniqueValues.add(null);
            } else {
                BytesRef term = BytesRef.deepCopyOf(this.countFieldTermIndex.lookupOrd(countOrd));
                gc.uniqueValues.add(term);
            }
            gc.ords = Arrays.copyOf(gc.ords, gc.ords.length + 1);
            gc.ords[gc.ords.length - 1] = countOrd;
            if (gc.ords.length > 1) {
                Arrays.sort(gc.ords);
            }
        }
    }

    private boolean doesNotContainOrd(int ord, int[] ords) {
        if (ords.length == 0) {
            return true;
        }
        if (ords.length == 1) {
            return ord != ords[0];
        }
        return Arrays.binarySearch(ords, ord) < 0;
    }

    @Override
    public List<DistinctValuesCollector.GroupCount<BytesRef>> getGroups() {
        return new ArrayList<DistinctValuesCollector.GroupCount<BytesRef>>(this.groups);
    }

    @Override
    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.groupFieldTermIndex = DocValues.getSorted(context.reader(), this.groupField);
        this.countFieldTermIndex = DocValues.getSorted(context.reader(), this.countField);
        this.ordSet.clear();
        for (TermGroupCount group : this.groups) {
            int groupOrd;
            int n = groupOrd = group.groupValue == null ? -1 : this.groupFieldTermIndex.lookupTerm((BytesRef)group.groupValue);
            if (group.groupValue != null && groupOrd < 0) continue;
            this.groupCounts[this.ordSet.put((int)groupOrd)] = group;
            group.ords = new int[group.uniqueValues.size()];
            Arrays.fill(group.ords, -2);
            int i = 0;
            for (BytesRef value : group.uniqueValues) {
                int countOrd;
                int n2 = countOrd = value == null ? -1 : this.countFieldTermIndex.lookupTerm(value);
                if (value != null && countOrd < 0) continue;
                group.ords[i++] = countOrd;
            }
        }
    }

    public static class TermGroupCount
    extends DistinctValuesCollector.GroupCount<BytesRef> {
        int[] ords;

        TermGroupCount(BytesRef groupValue) {
            super(groupValue);
        }
    }
}

