/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.search.uhighlight;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.Analyzer;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.TokenStream;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.IndexReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.PostingsEnum;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.uhighlight.AnalysisOffsetStrategy;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.uhighlight.PhraseHelper;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.BytesRef;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.automaton.Automata;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.automaton.CharacterRunAutomaton;

public class TokenStreamOffsetStrategy
extends AnalysisOffsetStrategy {
    private static final BytesRef[] ZERO_LEN_BYTES_REF_ARRAY = new BytesRef[0];

    public TokenStreamOffsetStrategy(String field, BytesRef[] terms, PhraseHelper phraseHelper, CharacterRunAutomaton[] automata, Analyzer indexAnalyzer) {
        super(field, ZERO_LEN_BYTES_REF_ARRAY, phraseHelper, TokenStreamOffsetStrategy.convertTermsToAutomata(terms, automata), indexAnalyzer);
        assert (!phraseHelper.hasPositionSensitivity());
    }

    private static CharacterRunAutomaton[] convertTermsToAutomata(BytesRef[] terms, CharacterRunAutomaton[] automata) {
        CharacterRunAutomaton[] newAutomata = new CharacterRunAutomaton[terms.length + automata.length];
        for (int i = 0; i < terms.length; ++i) {
            final String termString = terms[i].utf8ToString();
            newAutomata[i] = new CharacterRunAutomaton(Automata.makeString(termString)){

                @Override
                public String toString() {
                    return termString;
                }
            };
        }
        System.arraycopy(automata, 0, newAutomata, terms.length, automata.length);
        return newAutomata;
    }

    @Override
    public List<OffsetsEnum> getOffsetsEnums(IndexReader reader, int docId, String content) throws IOException {
        TokenStream tokenStream = this.tokenStream(content);
        TokenStreamPostingsEnum mtqPostingsEnum = new TokenStreamPostingsEnum(tokenStream, this.automata);
        ((DocIdSetIterator)mtqPostingsEnum).advance(docId);
        return Collections.singletonList(new OffsetsEnum(null, mtqPostingsEnum));
    }

    private static class TokenStreamPostingsEnum
    extends PostingsEnum
    implements Closeable {
        TokenStream stream;
        final CharacterRunAutomaton[] matchers;
        final CharTermAttribute charTermAtt;
        final OffsetAttribute offsetAtt;
        int currentDoc = -1;
        int currentMatch = -1;
        int currentStartOffset = -1;
        int currentEndOffset = -1;
        final BytesRef[] matchDescriptions;

        TokenStreamPostingsEnum(TokenStream ts, CharacterRunAutomaton[] matchers) throws IOException {
            this.stream = ts;
            this.matchers = matchers;
            this.matchDescriptions = new BytesRef[matchers.length];
            this.charTermAtt = ts.addAttribute(CharTermAttribute.class);
            this.offsetAtt = ts.addAttribute(OffsetAttribute.class);
            ts.reset();
        }

        @Override
        public int nextPosition() throws IOException {
            if (this.stream != null) {
                while (this.stream.incrementToken()) {
                    for (int i = 0; i < this.matchers.length; ++i) {
                        if (!this.matchers[i].run(this.charTermAtt.buffer(), 0, this.charTermAtt.length())) continue;
                        this.currentStartOffset = this.offsetAtt.startOffset();
                        this.currentEndOffset = this.offsetAtt.endOffset();
                        this.currentMatch = i;
                        return 0;
                    }
                }
                this.stream.end();
                this.close();
            }
            this.currentEndOffset = Integer.MAX_VALUE;
            this.currentStartOffset = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public int freq() throws IOException {
            return Integer.MAX_VALUE;
        }

        @Override
        public int startOffset() throws IOException {
            assert (this.currentStartOffset >= 0);
            return this.currentStartOffset;
        }

        @Override
        public int endOffset() throws IOException {
            assert (this.currentEndOffset >= 0);
            return this.currentEndOffset;
        }

        @Override
        public BytesRef getPayload() throws IOException {
            if (this.matchDescriptions[this.currentMatch] == null) {
                this.matchDescriptions[this.currentMatch] = new BytesRef(this.matchers[this.currentMatch].toString());
            }
            return this.matchDescriptions[this.currentMatch];
        }

        @Override
        public int docID() {
            return this.currentDoc;
        }

        @Override
        public int nextDoc() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int advance(int target) throws IOException {
            this.currentDoc = target;
            return this.currentDoc;
        }

        @Override
        public long cost() {
            return 0L;
        }

        @Override
        public void close() throws IOException {
            if (this.stream != null) {
                this.stream.close();
                this.stream = null;
            }
        }
    }
}

