/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial.bbox;

import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.DocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReader;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.LeafReaderContext;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.index.NumericDocValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function.FunctionValues;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.queries.function.ValueSource;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.search.Explanation;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.spatial.bbox.BBoxStrategy;
import org.graylog.shaded.elasticsearch5.org.apache.lucene.util.Bits;
import org.locationtech.spatial4j.shape.Rectangle;

class BBoxValueSource
extends ValueSource {
    private final BBoxStrategy strategy;

    public BBoxValueSource(BBoxStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public String description() {
        return "bboxShape(" + this.strategy.getFieldName() + ")";
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        LeafReader reader = readerContext.reader();
        final NumericDocValues minX = DocValues.getNumeric(reader, this.strategy.field_minX);
        final NumericDocValues minY = DocValues.getNumeric(reader, this.strategy.field_minY);
        final NumericDocValues maxX = DocValues.getNumeric(reader, this.strategy.field_maxX);
        final NumericDocValues maxY = DocValues.getNumeric(reader, this.strategy.field_maxY);
        final Bits validBits = DocValues.getDocsWithField(reader, this.strategy.field_minX);
        final Rectangle rect = this.strategy.getSpatialContext().makeRectangle(0.0, 0.0, 0.0, 0.0);
        return new FunctionValues(){

            @Override
            public Object objectVal(int doc) {
                if (!validBits.get(doc)) {
                    return null;
                }
                rect.reset(Double.longBitsToDouble(minX.get(doc)), Double.longBitsToDouble(maxX.get(doc)), Double.longBitsToDouble(minY.get(doc)), Double.longBitsToDouble(maxY.get(doc)));
                return rect;
            }

            @Override
            public String strVal(int doc) {
                Object v = this.objectVal(doc);
                return v == null ? null : v.toString();
            }

            @Override
            public boolean exists(int doc) {
                return validBits.get(doc);
            }

            @Override
            public Explanation explain(int doc) {
                return Explanation.match(Float.NaN, this.toString(doc), new Explanation[0]);
            }

            @Override
            public String toString(int doc) {
                return BBoxValueSource.this.description() + '=' + this.strVal(doc);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BBoxValueSource that = (BBoxValueSource)o;
        return this.strategy.equals(that.strategy);
    }

    @Override
    public int hashCode() {
        return this.strategy.hashCode();
    }
}

